/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.cmdinstruction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;

public abstract class SubCommand {
    private String name;
    private String permission;
    private List<SubCommand> subcommands;
    private List<String> tabCompletions;
    private boolean requiresArgs;

    public abstract void execute(CommandSender var1, String[] var2);

    public void handleCommand(CommandSender sender, String[] args) {
        if (this.getPermission() != null && !sender.hasPermission(this.getPermission())) {
            sender.sendMessage("You do not have permission to use this command.");
            return;
        }
        if (this.getSubcommands() != null && this.getSubcommands().size() > 0) {
            for (SubCommand subCommand : this.getSubcommands()) {
                if (!subCommand.getName().equalsIgnoreCase(args[0])) continue;
                subCommand.handleCommand(sender, args);
                return;
            }
        }
        if (this.isRequiresArgs() && args.length < 1) {
            sender.sendMessage("You must have more arguments.");
            return;
        }
        this.execute(sender, args);
    }

    public List<String> handleTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        if (this.getSubcommands() != null && this.getSubcommands().size() > 0) {
            for (SubCommand subcommand : this.subcommands) {
                if (!subcommand.getName().equalsIgnoreCase(args[0])) continue;
                return subcommand.getTabCompletions();
            }
        }
        return this.tabCompletions;
    }

    public SubCommand setName(String name) {
        this.name = name;
        return this;
    }

    public SubCommand setSubcommands(SubCommand ... subcommands) {
        this.subcommands = Arrays.asList(subcommands);
        return this;
    }

    public SubCommand setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public SubCommand setRequiresArgs(boolean requiresArgs) {
        this.requiresArgs = requiresArgs;
        return this;
    }

    public SubCommand setTabCompletions(List<String> tabCompletions) {
        this.tabCompletions = tabCompletions;
        return this;
    }

    public SubCommand setTabCompletions(String ... tabCompletions) {
        this.tabCompletions = Arrays.asList(tabCompletions);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<SubCommand> getSubcommands() {
        return this.subcommands;
    }

    public List<String> getTabCompletions() {
        return this.tabCompletions;
    }

    public boolean isRequiresArgs() {
        return this.requiresArgs;
    }
}

