/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.cmdinstruction;

import com.imjustdoom.cmdinstruction.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public abstract class Command
implements CommandExecutor,
TabCompleter {
    private String name;
    private String permission;
    private List<SubCommand> subcommands;
    private List<String> tabCompletions;
    private boolean requiresArgs;

    public abstract void execute(CommandSender var1, String[] var2);

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        if (this.getPermission() != null && !sender.hasPermission(this.getPermission())) {
            sender.sendMessage("You do not have permission to use this command.");
            return true;
        }
        if (this.getSubcommands().size() > 0 && args.length > 0) {
            for (SubCommand subCommand : this.getSubcommands()) {
                if (!subCommand.getName().equalsIgnoreCase(args[0])) continue;
                subCommand.handleCommand(sender, args);
                return true;
            }
        }
        if (this.isRequiresArgs() && args.length < 1) {
            sender.sendMessage("You must have more arguments.");
            return true;
        }
        this.execute(sender, args);
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        for (SubCommand subcommand : this.subcommands) {
            if (!subcommand.getName().equalsIgnoreCase(args[0])) continue;
            return subcommand.handleTabComplete(sender, args);
        }
        return this.tabCompletions;
    }

    public Command setName(String name) {
        this.name = name;
        return this;
    }

    public Command setSubcommands(SubCommand ... subcommands) {
        this.subcommands = Arrays.asList(subcommands);
        return this;
    }

    public Command setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public Command setRequiresArgs(boolean requiresArgs) {
        this.requiresArgs = requiresArgs;
        return this;
    }

    public Command setTabCompletions(List<String> tabCompletions) {
        this.tabCompletions = tabCompletions;
        return this;
    }

    public Command setTabCompletions(String ... tabCompletions) {
        this.tabCompletions = Arrays.asList(tabCompletions);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<SubCommand> getSubcommands() {
        return this.subcommands;
    }

    public List<String> getTabCompletions() {
        return this.tabCompletions;
    }

    public boolean isRequiresArgs() {
        return this.requiresArgs;
    }
}

