/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.message.msg;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.manager.PlayerManager;
import com.imjustdoom.bettermessages.message.Message;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class WorldChangeMessage
extends Message {
    public WorldChangeMessage(String parent, List<String> message, List<String> commands, List<Integer> count, boolean permission, boolean enabled, List<String> audience, String storageType, String dontRunIf, long delay, int priority, String messageType) {
        super(parent, message, commands, count, permission, enabled, audience, storageType, dontRunIf, delay, priority, messageType);
    }

    public WorldChangeMessage(String parent, List<String> message, List<String> commands, List<Integer> count, boolean permission, boolean enabled, List<String> audience, String storageType, String dontRunIf, long delay, int priority, String messageType, String extraInfo) {
        super(parent, message, commands, count, permission, enabled, audience, storageType, dontRunIf, delay, priority, messageType, extraInfo);
    }

    @Override
    public boolean otherChecks(Player player, Event event) {
        PlayerChangedWorldEvent worldEvent = (PlayerChangedWorldEvent)event;
        if (this.getExtraInfo() != null) {
            String from = this.getExtraInfo().split("/")[0];
            String to = this.getExtraInfo().split("/")[1];
            if (!from.equalsIgnoreCase(worldEvent.getFrom().getName()) || !player.getWorld().getName().equalsIgnoreCase(to)) {
                return false;
            }
        }
        if (PlayerManager.waiting.containsKey(player.getUniqueId()) && this.getDontRunIf().equalsIgnoreCase(PlayerManager.waiting.get(player.getUniqueId()).getName())) {
            PlayerManager.removeWaitingPlayer(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public int getCount(Player player) {
        return BetterMessages.getInstance().getStorage().getCount(player.getUniqueId(), this.getParent());
    }
}

