/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.message.msg;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.listener.event.ServerSwitchEvent;
import com.imjustdoom.bettermessages.manager.PlayerManager;
import com.imjustdoom.bettermessages.message.Message;
import java.util.List;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class SwitchServerMessage
extends Message {
    public SwitchServerMessage(String parent, List<String> message, List<String> commands, List<Integer> count, boolean permission, boolean enabled, List<String> audience, String storageType, String dontRunIf, long delay, int priority, String messageType) {
        super(parent, message, commands, count, permission, enabled, audience, storageType, dontRunIf, delay, priority, messageType);
    }

    public SwitchServerMessage(String parent, List<String> message, List<String> commands, List<Integer> count, boolean permission, boolean enabled, List<String> audience, String storageType, String dontRunIf, long delay, int priority, String messageType, String extraInfo) {
        super(parent, message, commands, count, permission, enabled, audience, storageType, dontRunIf, delay, priority, messageType, extraInfo);
    }

    @Override
    public int getCount(Player player) {
        return this.getStorageType().equals("default") ? BetterMessages.getInstance().getStorage().getCount(player.getUniqueId(), this.getParent()) : player.getStatistic(Statistic.RECORD_PLAYED) + 1;
    }

    @Override
    public boolean otherChecks(Player player, Event event) {
        ServerSwitchEvent switchEvent = (ServerSwitchEvent)event;
        if (this.getExtraInfo() != null) {
            String from = this.getExtraInfo().split("/")[0];
            String to = this.getExtraInfo().split("/")[1];
            if (!from.equalsIgnoreCase(switchEvent.getFrom()) || !switchEvent.getTo().equalsIgnoreCase(to)) {
                return false;
            }
        }
        if (PlayerManager.waiting.containsKey(player.getUniqueId()) && this.getDontRunIf().equalsIgnoreCase(PlayerManager.waiting.get(player.getUniqueId()).getName())) {
            PlayerManager.removeWaitingPlayer(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public String translateCustomPlaceholders(String message) {
        return message.replace("{from}", this.getExtraInfo().split("/")[0]).replace("{to}", this.getExtraInfo().split("/")[1]);
    }
}

