/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.message;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.message.MessageType;
import com.imjustdoom.bettermessages.message.type.ActionBarMessageType;
import com.imjustdoom.bettermessages.message.type.ChatMessageType;
import com.imjustdoom.bettermessages.message.type.TitleMessageType;
import com.imjustdoom.bettermessages.util.MessageUtil;
import java.util.List;
import java.util.Random;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Message {
    private String parent;
    private List<String> message;
    private List<String> commands;
    private List<Integer> count;
    private boolean permission;
    private boolean enabled;
    private String storageType;
    private String dontRunIf;
    private String permissionString;
    private String extraInfo;
    private List<String> audience;
    private long delay;
    private int priority;
    private MessageType messageType;

    public Message(String parent, List<String> message, List<String> commands, List<Integer> count, boolean permission, boolean enabled, List<String> audience, String storageType, String dontRunIf, long delay, int priority, String messageType) {
        this(parent, message, commands, count, permission, enabled, audience, storageType, dontRunIf, delay, priority, messageType, null);
    }

    public Message(String parent, List<String> message, List<String> commands, List<Integer> count, boolean permission, boolean enabled, List<String> audience, String storageType, String dontRunIf, long delay, int priority, String messageType, String extraInfo) {
        this.parent = parent;
        this.message = message;
        this.commands = commands;
        this.count = count;
        this.permission = permission;
        this.enabled = enabled;
        this.audience = audience;
        this.storageType = storageType;
        this.dontRunIf = dontRunIf;
        this.permissionString = "bettermessages." + this.parent;
        this.delay = delay;
        this.priority = priority;
        this.extraInfo = extraInfo;
        if (messageType.equalsIgnoreCase("title")) {
            this.messageType = new TitleMessageType();
        } else if (messageType.equalsIgnoreCase("actionbar")) {
            this.messageType = new ActionBarMessageType();
        } else if (!messageType.equalsIgnoreCase("bossbar")) {
            this.messageType = new ChatMessageType();
        }
    }

    public String getMessage() {
        if (this.message.size() == 1) {
            return this.message.get(0);
        }
        return this.message.get(new Random().nextInt(this.message.size()));
    }

    public boolean canRun(Player player, Event event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.isPermission() && !player.hasPermission(this.getPermissionString())) {
            return false;
        }
        if (!this.hasValidCount(this.getCount(player))) {
            return false;
        }
        return event == null || this.otherChecks(player, event);
    }

    public boolean otherChecks(Player player, Event event) {
        return true;
    }

    public int getCount(Player player) {
        return -1;
    }

    public boolean hasValidCount(int count) {
        return this.getCount().contains(count) || this.getCount().contains(-1);
    }

    public String translateCustomPlaceholders(String message) {
        return message;
    }

    public void sendMessage(Player player) {
        Bukkit.getScheduler().scheduleAsyncDelayedTask((Plugin)BetterMessages.getInstance(), () -> {
            String tempMsg = BetterMessages.getInstance().getStorage().getMessage(player.getUniqueId(), this.getParent()).equals("") ? this.getMessage() : BetterMessages.getInstance().getStorage().getMessage(player.getUniqueId(), this.getParent());
            String message = this.translatePlaceholders(tempMsg, player);
            for (String command : this.getCommands()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BetterMessages.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.translatePlaceholders(command, player)));
            }
            block11: for (String audience : this.getAudience()) {
                String a;
                String[] split = audience.split("\\|");
                boolean ignoreUser = false;
                String permission = null;
                for (String s : split) {
                    String perm;
                    if (s.equalsIgnoreCase("ignore-user")) {
                        ignoreUser = true;
                    }
                    if (!s.contains("permission:") || !player.hasPermission(perm = s.split(":")[1])) continue;
                    permission = perm;
                }
                String withoutExtras = ignoreUser ? audience.split("\\|")[0] : audience;
                switch (a = withoutExtras.split("/")[0]) {
                    case "server": {
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            if (ignoreUser && p.getUniqueId().equals(player.getUniqueId()) || permission != null && !p.hasPermission(permission)) continue;
                            this.messageType.send(p, message);
                        }
                        continue block11;
                    }
                    case "world": {
                        if (audience.startsWith("world/")) {
                            for (Player p : Bukkit.getWorld((String)withoutExtras.replace("world/", "")).getPlayers()) {
                                if (ignoreUser && p.getUniqueId().equals(player.getUniqueId()) || permission != null && !p.hasPermission(permission)) continue;
                                this.messageType.send(p, message);
                            }
                            return;
                        }
                        for (Player p : player.getWorld().getPlayers()) {
                            if (ignoreUser && p.getUniqueId().equals(player.getUniqueId()) || permission != null && !p.hasPermission(permission)) continue;
                            this.messageType.send(p, message);
                        }
                        continue block11;
                    }
                    case "user": {
                        if (permission != null && !player.hasPermission(permission)) break;
                        this.messageType.send(player, message);
                        break;
                    }
                    default: {
                        System.err.println("Unknown audience type");
                    }
                }
            }
        }, this.getDelay());
    }

    private String translatePlaceholders(String message, Player player) {
        message = this.translateCustomPlaceholders(message);
        message = message.replace("{player}", player.getName()).replace("{world}", player.getWorld().getName()).replace("{line}", "\n").replace("{stat}", String.valueOf(this.getCount(player)));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        return MessageUtil.translate(message);
    }

    public String getParent() {
        return this.parent;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<Integer> getCount() {
        return this.count;
    }

    public boolean isPermission() {
        return this.permission;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public String getDontRunIf() {
        return this.dontRunIf;
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public long getDelay() {
        return this.delay;
    }

    public int getPriority() {
        return this.priority;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setMessage(List<String> message) {
        this.message = message;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public void setCount(List<Integer> count) {
        this.count = count;
    }

    public void setPermission(boolean permission) {
        this.permission = permission;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public void setDontRunIf(String dontRunIf) {
        this.dontRunIf = dontRunIf;
    }

    public void setPermissionString(String permissionString) {
        this.permissionString = permissionString;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }
}

