/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.listener;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.config.Config;
import com.imjustdoom.bettermessages.manager.PlayerManager;
import com.imjustdoom.bettermessages.message.EventType;
import com.imjustdoom.bettermessages.message.Message;
import com.imjustdoom.bettermessages.util.VanishUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerQuitListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void quitEvent(PlayerQuitEvent event) {
        if (Config.BUNGEECORD_MODE) {
            event.setQuitMessage(null);
            return;
        }
        Player player = event.getPlayer();
        PlayerManager.removePlayer(player.getUniqueId());
        if (VanishUtil.isVanished(player) || player.hasPermission("bettermessages.silent-quit")) {
            event.setQuitMessage(null);
            return;
        }
        Message pMessage = null;
        for (Message msg : Config.MESSAGES.get(EventType.QUIT.getClazz())) {
            BetterMessages.getInstance().getStorage().update(player.getUniqueId(), msg.getParent());
            if (!msg.canRun(player, (Event)event)) continue;
            if (msg.getPriority() != -1) {
                if (pMessage == null) {
                    pMessage = msg;
                    continue;
                }
                if (msg.getPriority() >= pMessage.getPriority()) continue;
                pMessage = msg;
                continue;
            }
            event.setQuitMessage(null);
            msg.sendMessage(player);
        }
        if (pMessage != null) {
            event.setQuitMessage(null);
            pMessage.sendMessage(player);
        }
    }
}

