/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.listener;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.config.Config;
import com.imjustdoom.bettermessages.listener.event.ServerSwitchEvent;
import com.imjustdoom.bettermessages.manager.PlayerManager;
import com.imjustdoom.bettermessages.message.EventType;
import com.imjustdoom.bettermessages.message.Message;
import com.imjustdoom.bettermessages.util.VanishUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeCordListener
implements PluginMessageListener {
    private int test = 0;

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals("BungeeCord") && !channel.equals("bettermessages:main")) {
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
        try {
            String subChannel;
            switch (subChannel = in.readUTF()) {
                case "ServerSwitchEvent": {
                    String playerString = in.readUTF();
                    String fromServer = in.readUTF();
                    String toServer = in.readUTF();
                    ServerSwitchEvent event = new ServerSwitchEvent(Bukkit.getPlayer((String)playerString), fromServer, toServer);
                    BetterMessages.getInstance().getServer().getPluginManager().callEvent((Event)event);
                    break;
                }
                case "Join": {
                    String playerString = in.readUTF();
                    String toServer = in.readUTF();
                    Player p = Bukkit.getPlayer((String)playerString);
                    PlayerManager.addWaitingPlayer(p.getUniqueId(), p.getWorld());
                    PlayerManager.removePlayer(p.getUniqueId());
                    if (VanishUtil.isVanished(p) || p.hasPermission("bettermessages.silent-join")) {
                        return;
                    }
                    Message pMessage = null;
                    for (Message msg : Config.MESSAGES.get(EventType.JOIN.getClazz())) {
                        if (!msg.canRun(p, null)) continue;
                        BetterMessages.getInstance().getStorage().update(p.getUniqueId(), msg.getParent());
                        if (msg.getPriority() != -1) {
                            if (pMessage == null) {
                                pMessage = msg;
                                continue;
                            }
                            if (msg.getPriority() >= pMessage.getPriority()) continue;
                            pMessage = msg;
                            continue;
                        }
                        msg.sendMessage(p);
                    }
                    if (pMessage == null) break;
                    pMessage.sendMessage(p);
                    break;
                }
                case "Quit": {
                    String playerString = in.readUTF();
                    String toServer = in.readUTF();
                    Player p = Bukkit.getPlayer((String)playerString);
                    PlayerManager.removePlayer(p.getUniqueId());
                    if (VanishUtil.isVanished(p) || p.hasPermission("bettermessages.silent-quit")) {
                        return;
                    }
                    Message pMessage = null;
                    for (Message msg : Config.MESSAGES.get(EventType.QUIT.getClazz())) {
                        if (!msg.canRun(p, null)) continue;
                        BetterMessages.getInstance().getStorage().update(p.getUniqueId(), msg.getParent());
                        if (msg.getPriority() != -1) {
                            if (pMessage == null) {
                                pMessage = msg;
                                continue;
                            }
                            if (msg.getPriority() >= pMessage.getPriority()) continue;
                            pMessage = msg;
                            continue;
                        }
                        msg.sendMessage(p);
                    }
                    if (pMessage == null) break;
                    pMessage.sendMessage(p);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

