/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.config;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.message.EventType;
import com.imjustdoom.bettermessages.message.Message;
import com.imjustdoom.bettermessages.message.MessageBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    public static final int LATEST_CONFIG_VERSION = 16;
    public static boolean DISABLE_OUTDATED_CONFIG_WARNING;
    public static int CONFIG_VERSION;
    public static boolean CHECK_FOR_UPDATES;
    public static boolean BUNGEECORD_MODE;
    public static final Map<Class<? extends Message>, List<Message>> MESSAGES;

    public static void init() {
        BetterMessages.getInstance().reloadConfig();
        MESSAGES.clear();
        for (EventType eventType : EventType.values()) {
            MESSAGES.put(eventType.getClazz(), new ArrayList());
        }
        DISABLE_OUTDATED_CONFIG_WARNING = Config.getConfig().getBoolean("disable-outdated-config-warning");
        CONFIG_VERSION = Config.getConfig().getInt("config-version");
        CHECK_FOR_UPDATES = Config.getConfig().getBoolean("check-for-updates");
        BUNGEECORD_MODE = Config.getConfig().getBoolean("bungeecord-mode");
        InternalMessages.PREFIX = Config.getConfig().getString("internal-messages.prefix");
        InternalMessages.HELP = Config.getConfig().getString("internal-messages.help");
        InternalMessages.RELOADED = Config.getConfig().getString("internal-messages.reloaded");
        InternalMessages.HELP_REDIRECT = Config.getConfig().getString("internal-messages.help-redirect");
        InternalMessages.CHANGED_MESSAGE = Config.getConfig().getString("internal-messages.changed-message");
        for (String msg : Config.getConfig().getConfigurationSection("messages").getKeys(false)) {
            boolean permission;
            List<String> messages = Config.getConfig().isString("messages." + msg + ".message") ? Collections.singletonList(Config.getConfig().getString("messages." + msg + ".message")) : Config.getConfig().getStringList("messages." + msg + ".message");
            List<Integer> count = Config.getConfig().isInt("messages." + msg + ".count") ? (Config.getConfig().getInt("messages." + msg + ".count") == -1 ? Collections.singletonList(-1) : Collections.singletonList(Config.getConfig().getInt("messages." + msg + ".count"))) : Config.getConfig().getIntegerList("messages." + msg + ".count");
            if (Config.getConfig().isString("messages." + msg + ".permission")) {
                BetterMessages.getInstance().getLogger().warning("The permission option in the config is now a boolean (true/false). Please update your config.");
                permission = false;
            } else {
                permission = Config.getConfig().getBoolean("messages." + msg + ".permission");
            }
            String messageType = Config.getConfig().getString("messages." + msg + ".message-type");
            List<String> audience = Config.getConfig().isString("messages." + msg + ".audience") ? Collections.singletonList(Config.getConfig().getString("messages." + msg + ".audience")) : Config.getConfig().getStringList("messages." + msg + ".audience");
            for (String type : Config.getConfig().getStringList("messages." + msg + ".activation")) {
                String extraInfo = null;
                if (type.contains("/")) {
                    extraInfo = type.split("/", 2)[1];
                    type = type.split("/")[0];
                }
                EventType eventType = EventType.valueOf(type.toUpperCase().replaceAll("-", "_"));
                Message message = new MessageBuilder().setParent(msg).setMessage(messages).setCommands(Config.getConfig().getStringList("messages." + msg + ".commands")).setCount(count).setPermission(permission).setEnabled(Config.getConfig().getBoolean("messages." + msg + ".enabled")).setAudience(audience).setStorageType(Config.getConfig().getString("messages." + msg + ".storage-type")).setDontRunIf(Config.getConfig().getString("messages." + msg + ".world") == null ? "" : Config.getConfig().getString("messages." + msg + ".world")).setDelay(Config.getConfig().getInt("messages." + msg + ".delay")).setPriority(Config.getConfig().getInt("messages." + msg + ".priority")).setExtraInfo(extraInfo).setMessageType(messageType).build(eventType);
                MESSAGES.get(message.getClass()).add(message);
            }
        }
    }

    private static FileConfiguration getConfig() {
        return BetterMessages.getInstance().getConfig();
    }

    public static void isConfigUpToDate() {
        if (CONFIG_VERSION != 16 && !DISABLE_OUTDATED_CONFIG_WARNING) {
            BetterMessages.getInstance().getLogger().warning("The config file needs to be regenerated as it's not the latest version and could have unexpected results.");
        }
    }

    static {
        MESSAGES = new HashMap<Class<? extends Message>, List<Message>>();
    }

    public static class InternalMessages {
        public static String PREFIX;
        public static String HELP;
        public static String RELOADED;
        public static String HELP_REDIRECT;
        public static String CHANGED_MESSAGE;
    }
}

