/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages.command.subcommand;

import com.imjustdoom.bettermessages.BetterMessages;
import com.imjustdoom.bettermessages.config.Config;
import com.imjustdoom.bettermessages.message.Message;
import com.imjustdoom.bettermessages.util.MessageUtil;
import com.imjustdoom.cmdinstruction.SubCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditOtherMessageCmd
extends SubCommand {
    public EditOtherMessageCmd() {
        ArrayList<String> list = new ArrayList<String>();
        for (List<Message> msgList : Config.MESSAGES.values()) {
            for (Message msg : msgList) {
                list.add(msg.getParent());
            }
        }
        this.setTabCompletions(list);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        Player player = Bukkit.getPlayer((String)args[1]);
        if (!sender.hasPermission("bettermessages.editmsg.other")) {
            sender.sendMessage("You don't have permission for this command");
            return;
        }
        if (args.length < 4) {
            sender.sendMessage("You must specify a message to edit and what to set it as");
            return;
        }
        if (!Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).isOnline()) {
            sender.sendMessage("Can't find player");
            return;
        }
        for (List<Message> msgList : Config.MESSAGES.values()) {
            for (Message msg : msgList) {
                if (!msg.getParent().equalsIgnoreCase(args[2])) continue;
                if (player.hasPermission("bettermessages.editmsg." + msg.getParent())) {
                    player.sendMessage("\u00a7cYou do not have permission to edit this message.");
                    return;
                }
                StringBuilder message = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    message.append(args[i]).append(" ");
                }
                BetterMessages.getInstance().getStorage().updateMessage(player.getUniqueId(), "messages." + msg.getParent(), message.toString());
                player.sendMessage(MessageUtil.translate(Config.InternalMessages.CHANGED_MESSAGE).replace("{message}", args[2]));
            }
        }
    }
}

