/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.bettermessages;

import com.imjustdoom.bettermessages.UpdateChecker;
import com.imjustdoom.bettermessages.command.BetterMessagesCmd;
import com.imjustdoom.bettermessages.config.Config;
import com.imjustdoom.bettermessages.listener.BungeeCordListener;
import com.imjustdoom.bettermessages.listener.PlayerJoinListener;
import com.imjustdoom.bettermessages.listener.PlayerPreLoginListener;
import com.imjustdoom.bettermessages.listener.PlayerQuitListener;
import com.imjustdoom.bettermessages.listener.PlayerWorldChangeListener;
import com.imjustdoom.bettermessages.listener.ReloadListener;
import com.imjustdoom.bettermessages.listener.ServerSwitchListener;
import com.imjustdoom.bettermessages.metrics.Metrics;
import com.imjustdoom.bettermessages.storage.Storage;
import com.imjustdoom.cmdinstruction.CMDInstruction;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class BetterMessages
extends JavaPlugin {
    private static BetterMessages INSTANCE;
    private Storage storage;

    public BetterMessages() {
        INSTANCE = this;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        Config.init();
        Config.isConfigUpToDate();
        this.storage = new Storage();
        CMDInstruction.registerCommands(this, new BetterMessagesCmd().setName("bettermessages").setPermission("bettermessages"));
        if (Config.BUNGEECORD_MODE) {
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)new BungeeCordListener());
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "bettermessages:main", (PluginMessageListener)new BungeeCordListener());
        }
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerPreLoginListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerQuitListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerWorldChangeListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ServerSwitchListener(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("BetterReload") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new ReloadListener(), (Plugin)this);
        }
        try {
            if (Config.CHECK_FOR_UPDATES) {
                this.getLogger().warning(UpdateChecker.checkUpdates(this.getDescription().getVersion()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().warning("The above error will not affect the plugins abilities. It just failed to check for an update. You can disable this in the config file");
        }
        Metrics metrics = new Metrics(this, 8591);
        metrics.addCustomChart(new Metrics.MultiLineChart("players_and_servers", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            valueMap.put("servers", 1);
            valueMap.put("players", Bukkit.getOnlinePlayers().size());
            return valueMap;
        }));
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
    }

    public static BetterMessages getInstance() {
        return INSTANCE;
    }

    public Storage getStorage() {
        return this.storage;
    }
}

