/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.transitive;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.Util;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.transitive.ExcludedDependency;
import org.jetbrains.annotations.NotNull;

public class TransitiveDependencyHelper {
    private static final String TRANSITIVE_DEPENDENCY_COLLECTOR_CLASS = Util.replaceWithDots("com{}alessiodp{}libby{}maven{}resolver{}TransitiveDependencyCollector");
    private static final String ARTIFACT_CLASS = Util.replaceWithDots("org{}eclipse{}aether{}artifact{}Artifact");
    private final Object transitiveDependencyCollectorObject;
    private final Method resolveTransitiveDependenciesMethod;
    private final Method artifactGetGroupIdMethod;
    private final Method artifactGetArtifactIdMethod;
    private final Method artifactGetVersionMethod;
    private final Method artifactGetBaseVersionMethod;
    private final Method artifactGetClassifierMethod;
    private final LibraryManager libraryManager;

    public TransitiveDependencyHelper(@NotNull LibraryManager object, @NotNull Path path) {
        Objects.requireNonNull(object, "libraryManager");
        this.libraryManager = object;
        Object object2 = new IsolatedClassLoader(new URL[0]);
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("com{}alessiodp{}libby{}maven{}resolver").artifactId("libby-maven-resolver").version("1.0.1").checksumFromBase64("EmsSUwjtqSeYTt8WEw7LPI/5Yz8bWSxf23XcdLEM7dk=").repository("https://repo1.maven.org/maven2/").repository("https://repo.alessiodp.com/releases").build()));
        try {
            object = ((ClassLoader)object2).loadClass(TRANSITIVE_DEPENDENCY_COLLECTOR_CLASS);
            object2 = ((ClassLoader)object2).loadClass(ARTIFACT_CLASS);
            Constructor constructor = ((Class)object).getConstructor(Path.class);
            constructor.setAccessible(true);
            this.transitiveDependencyCollectorObject = constructor.newInstance(path);
            this.resolveTransitiveDependenciesMethod = ((Class)object).getMethod("findTransitiveDependencies", String.class, String.class, String.class, String.class, Stream.class);
            this.resolveTransitiveDependenciesMethod.setAccessible(true);
            this.artifactGetGroupIdMethod = ((Class)object2).getMethod("getGroupId", new Class[0]);
            this.artifactGetArtifactIdMethod = ((Class)object2).getMethod("getArtifactId", new Class[0]);
            this.artifactGetVersionMethod = ((Class)object2).getMethod("getVersion", new Class[0]);
            this.artifactGetBaseVersionMethod = ((Class)object2).getMethod("getBaseVersion", new Class[0]);
            this.artifactGetClassifierMethod = ((Class)object2).getMethod("getClassifier", new Class[0]);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @NotNull
    public Collection<Library> findTransitiveLibraries(@NotNull Library library) {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        HashSet<ExcludedDependency> hashSet = new HashSet<ExcludedDependency>(library.getExcludedTransitiveDependencies());
        Iterator iterator = this.libraryManager.getRepositories();
        Object object = library.getRepositories();
        if (iterator.isEmpty() && object.isEmpty()) {
            throw new IllegalArgumentException("No repositories have been added before resolving transitive dependencies");
        }
        iterator = Stream.of(iterator, object).flatMap(Collection::stream);
        try {
            iterator = (Collection)this.resolveTransitiveDependenciesMethod.invoke(this.transitiveDependencyCollectorObject, library.getGroupId(), library.getArtifactId(), library.getVersion(), library.getClassifier(), iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                object = (Map.Entry)object;
                Object object2 = object.getKey();
                object = (String)object.getValue();
                String string = (String)this.artifactGetGroupIdMethod.invoke(object2, new Object[0]);
                String string2 = (String)this.artifactGetArtifactIdMethod.invoke(object2, new Object[0]);
                String string3 = (String)this.artifactGetBaseVersionMethod.invoke(object2, new Object[0]);
                String string4 = (String)this.artifactGetClassifierMethod.invoke(object2, new Object[0]);
                if (library.getGroupId().equals(string) && library.getArtifactId().equals(string2) || hashSet.contains(new ExcludedDependency(string, string2))) continue;
                Library.Builder builder = Library.builder().groupId(string).artifactId(string2).version(string3).isolatedLoad(library.isIsolatedLoad()).loaderId(library.getLoaderId());
                if (string4 != null && !string4.isEmpty()) {
                    builder.classifier(string4);
                }
                library.getRelocations().forEach(builder::relocate);
                if (object != null) {
                    if (!((String)object).endsWith("/")) {
                        object = (String)object + '/';
                    }
                    object2 = (String)this.artifactGetVersionMethod.invoke(object2, new Object[0]);
                    string = Util.craftPartialPath(string2, string, string3);
                    object2 = Util.craftPath(string, string2, object2, string4);
                    builder.url((String)object + object2);
                } else {
                    library.getRepositories().forEach(builder::repository);
                }
                arrayList.add(builder.build());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

