/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.relocation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.Util;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.relocation.Relocation;
import org.jetbrains.annotations.NotNull;

public class RelocationHelper {
    private static final String JAR_RELOCATOR_CLASS = Util.replaceWithDots("me{}lucko{}jarrelocator{}JarRelocator");
    private static final String RELOCATION_CLASS = Util.replaceWithDots("me{}lucko{}jarrelocator{}Relocation");
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;
    private final Constructor<?> relocationConstructor;

    public RelocationHelper(@NotNull LibraryManager object) {
        Objects.requireNonNull(object, "libraryManager");
        Object object2 = new IsolatedClassLoader(new URL[0]);
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("org{}ow2{}asm").artifactId("asm-commons").version("9.2").checksumFromBase64("vkzlMTiiOLtSLNeBz5Hzulzi9sqT7GLUahYqEnIl4KY=").repository("https://repo1.maven.org/maven2/").build()));
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("org{}ow2{}asm").artifactId("asm").version("9.2").checksumFromBase64("udT+TXGTjfOIOfDspCqqpkz4sxPWeNoDbwyzyhmbR/U=").repository("https://repo1.maven.org/maven2/").build()));
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("me{}lucko").artifactId("jar-relocator").version("1.7").checksumFromBase64("b30RhOF6kHiHl+O5suNLh/+eAr1iOFEFLXhwkHHDu4I=").repository("https://repo1.maven.org/maven2/").build()));
        try {
            object = ((ClassLoader)object2).loadClass(JAR_RELOCATOR_CLASS);
            object2 = ((ClassLoader)object2).loadClass(RELOCATION_CLASS);
            this.jarRelocatorConstructor = ((Class)object).getConstructor(File.class, File.class, Collection.class);
            this.jarRelocatorRunMethod = ((Class)object).getMethod("run", new Class[0]);
            this.relocationConstructor = ((Class)object2).getConstructor(String.class, String.class, Collection.class, Collection.class);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void relocate(@NotNull Path path, @NotNull Path path2, @NotNull Collection<Relocation> object) {
        Objects.requireNonNull(path, "in");
        Objects.requireNonNull(path2, "out");
        Objects.requireNonNull(object, "relocations");
        try {
            LinkedList linkedList = new LinkedList();
            object = object.iterator();
            while (object.hasNext()) {
                Relocation relocation = (Relocation)object.next();
                linkedList.add(this.relocationConstructor.newInstance(relocation.getPattern(), relocation.getRelocatedPattern(), relocation.getIncludes(), relocation.getExcludes()));
            }
            this.jarRelocatorRunMethod.invoke(this.jarRelocatorConstructor.newInstance(path.toFile(), path2.toFile(), linkedList), new Object[0]);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

