/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.logging.adapters;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.extremall.advancedkits.libs.libby.logging.LogLevel;
import me.extremall.advancedkits.libs.libby.logging.adapters.LogAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDKLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JDKLogAdapter(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(@NotNull LogLevel logLevel, @Nullable String string) {
        switch (Objects.requireNonNull(logLevel, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, string);
                return;
            }
            case INFO: {
                this.logger.log(Level.INFO, string);
                return;
            }
            case WARN: {
                this.logger.log(Level.WARNING, string);
                return;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, string);
            }
        }
    }

    @Override
    public void log(@NotNull LogLevel logLevel, @Nullable String string, @Nullable Throwable throwable) {
        switch (Objects.requireNonNull(logLevel, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, string, throwable);
                return;
            }
            case INFO: {
                this.logger.log(Level.INFO, string, throwable);
                return;
            }
            case WARN: {
                this.logger.log(Level.WARNING, string, throwable);
                return;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, string, throwable);
            }
        }
    }
}

