/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.configuration;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.Util;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.configuration.Configuration;
import me.extremall.advancedkits.libs.libby.configuration.ConfigurationException;
import me.extremall.advancedkits.libs.libby.configuration.MalformedConfigurationException;
import me.extremall.advancedkits.libs.libby.relocation.Relocation;
import me.extremall.advancedkits.libs.libby.transitive.ExcludedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationFetcher {
    public static final int CONFIGURATION_VERSION = 0;
    private static final String JSON_PARSER_CLASS = Util.replaceWithDots("com{}grack{}nanojson{}JsonParser");
    private static final String JSON_PARSER_CONTEXT_CLASS = Util.replaceWithDots("com{}grack{}nanojson{}JsonParser$JsonParserContext");
    private static final String JSON_PARSER_EXCEPTION_CLASS = Util.replaceWithDots("com{}grack{}nanojson{}JsonParserException");
    private static final String JSON_OBJECT_CLASS = Util.replaceWithDots("com{}grack{}nanojson{}JsonObject");
    private static final String JSON_ARRAY_CLASS = Util.replaceWithDots("com{}grack{}nanojson{}JsonArray");
    private final Method jsonParserObject;
    private final Method jsonParserFrom;
    private final Method jsonObjectGetArray;
    private final Method jsonObjectGetBoolean;
    private final Method jsonObjectGetString;
    private final Method jsonArrayGetObject;
    private final Class<?> jsonParserException;

    public ConfigurationFetcher(@NotNull LibraryManager object) {
        Objects.requireNonNull(object, "libraryManager");
        IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader(new URL[0]);
        isolatedClassLoader.addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("com{}grack").artifactId("nanojson").version("1.8").checksumFromBase64("qyhAVZM8LYvqhGQrbmW2aHV4hRzn+2flPCV98wAimJo=").repository("https://repo1.maven.org/maven2/").build()));
        try {
            object = isolatedClassLoader.loadClass(JSON_PARSER_CLASS);
            Class<?> clazz = isolatedClassLoader.loadClass(JSON_PARSER_CONTEXT_CLASS);
            Class<?> clazz2 = isolatedClassLoader.loadClass(JSON_OBJECT_CLASS);
            Class<?> clazz3 = isolatedClassLoader.loadClass(JSON_ARRAY_CLASS);
            this.jsonParserException = isolatedClassLoader.loadClass(JSON_PARSER_EXCEPTION_CLASS);
            this.jsonParserObject = ((Class)object).getMethod("object", new Class[0]);
            this.jsonParserFrom = clazz.getMethod("from", InputStream.class);
            this.jsonObjectGetArray = clazz2.getMethod("getArray", String.class);
            this.jsonObjectGetBoolean = clazz2.getMethod("getBoolean", String.class);
            this.jsonObjectGetString = clazz2.getMethod("getString", String.class);
            this.jsonArrayGetObject = clazz3.getMethod("getObject", Integer.TYPE);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public Configuration readJsonFile(@NotNull InputStream list) {
        try {
            try {
                list = (Map)this.jsonParserFrom.invoke(this.jsonParserObject.invoke(null, new Object[0]), list);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.jsonParserException.isInstance(invocationTargetException.getCause())) {
                    throw new MalformedConfigurationException(invocationTargetException.getCause().getMessage(), invocationTargetException.getCause());
                }
                throw new RuntimeException(invocationTargetException);
            }
            Integer n2 = this.fetchVersion((Map<String, Object>)((Object)list));
            Set<String> set = this.fetchRepositories((Map<String, Object>)((Object)list));
            Set<Relocation> set2 = this.fetchRelocations((Map<String, Object>)((Object)list));
            list = this.fetchLibraries((Map<String, Object>)((Object)list), set2);
            return new Configuration(n2, set, set2, list);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private Integer fetchVersion(@NotNull Map<String, Object> object) {
        if ((object = object.get("version")) instanceof Number) {
            int n2 = ((Number)object).intValue();
            if (n2 != 0) {
                throw new ConfigurationException("The json file is version " + object + " but this version of libby only supports version 0");
            }
            return n2;
        }
        return null;
    }

    private Set<String> fetchRepositories(@NotNull Map<String, Object> iterator) {
        HashSet<String> hashSet = new HashSet<String>();
        if ((iterator = this.getArray((Map<String, Object>)((Object)iterator), "repositories")) != null) {
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 instanceof String) {
                    hashSet.add((String)e2);
                    continue;
                }
                throw new ConfigurationException("Invalid repository: " + e2);
            }
        }
        return hashSet;
    }

    private Set<Relocation> fetchRelocations(@NotNull Map<String, Object> object) {
        if ((object = this.getArray((Map<String, Object>)object, "relocations")) != null) {
            HashSet<Relocation> hashSet = new HashSet<Relocation>();
            for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                Object object2;
                Object object3;
                Map<String, Object> map = this.getObject((ArrayList<Object>)object, i2);
                if (map == null) {
                    throw new ConfigurationException("Invalid relocation: " + ((ArrayList)object).get(i2));
                }
                String string = this.getString(map, "pattern");
                if (string == null) {
                    throw new ConfigurationException("The pattern property is required for all relocations");
                }
                String string2 = this.getString(map, "relocatedPattern");
                if (string2 == null) {
                    throw new ConfigurationException("The relocatedPattern property is required for all relocations");
                }
                ArrayList<Object> arrayList = this.getArray(map, "includes");
                if (arrayList != null) {
                    object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        if (object2 instanceof String) continue;
                        throw new ConfigurationException("Invalid relocation include: " + object2);
                    }
                }
                if ((object3 = this.getArray(map, "excludes")) != null) {
                    object2 = ((ArrayList)object3).iterator();
                    while (object2.hasNext()) {
                        map = object2.next();
                        if (map instanceof String) continue;
                        throw new ConfigurationException("Invalid relocation exclude: " + map);
                    }
                }
                hashSet.add(new Relocation(string, string2, arrayList, (Collection<String>)object3));
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return Collections.emptySet();
    }

    @NotNull
    private Set<ExcludedDependency> fetchExcludedTransitiveDependencies(@NotNull Map<String, Object> object) {
        if ((object = this.getArray((Map<String, Object>)object, "excludedTransitiveDependencies")) != null) {
            HashSet<ExcludedDependency> hashSet = new HashSet<ExcludedDependency>();
            for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                Map<String, Object> map = this.getObject((ArrayList<Object>)object, i2);
                if (map == null) {
                    throw new ConfigurationException("Invalid excluded transitive dependency: " + ((ArrayList)object).get(i2));
                }
                String string = this.getString(map, "groupId");
                if (string == null) {
                    throw new ConfigurationException("The groupId property is required for all excluded transitive dependencies");
                }
                if ((map = this.getString(map, "artifactId")) == null) {
                    throw new ConfigurationException("The artifactId property is required for all excluded transitive dependencies");
                }
                hashSet.add(new ExcludedDependency(string, (String)((Object)map)));
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return Collections.emptySet();
    }

    private List<Library> fetchLibraries(@NotNull Map<String, Object> object, @NotNull Set<Relocation> set) {
        if ((object = this.getArray((Map<String, Object>)((Object)object), "libraries")) != null) {
            ArrayList<Library> arrayList = new ArrayList<Library>(object.size());
            for (int i2 = 0; i2 < object.size(); ++i2) {
                String string;
                Object object2 = this.getObject(object, i2);
                if (object2 == null) {
                    throw new ConfigurationException("Invalid library: " + object.get(i2));
                }
                Library.Builder builder = Library.builder();
                String string2 = this.getString((Map<String, Object>)object2, "groupId");
                if (string2 == null) {
                    throw new ConfigurationException("The groupId property is required for all libraries");
                }
                String string3 = this.getString((Map<String, Object>)object2, "artifactId");
                if (string3 == null) {
                    throw new ConfigurationException("The artifactId property is required for all libraries");
                }
                String string4 = this.getString((Map<String, Object>)object2, "version");
                if (string4 == null) {
                    throw new ConfigurationException("The version property is required for all libraries");
                }
                builder.groupId(string2).artifactId(string3).version(string4);
                String string5 = this.getString((Map<String, Object>)object2, "checksum");
                if (string5 != null) {
                    builder.checksum(string5);
                }
                if ((string = this.getString((Map<String, Object>)object2, "checksumFromBase64")) != null) {
                    try {
                        builder.checksumFromBase64(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ConfigurationException("The checksum property must be a valid base64 encoded SHA-256 checksum");
                    }
                }
                builder.isolatedLoad(this.getBoolean((Map<String, Object>)object2, "isolatedLoad"));
                builder.loaderId(this.getString((Map<String, Object>)object2, "loaderId"));
                builder.classifier(this.getString((Map<String, Object>)object2, "classifier"));
                builder.resolveTransitiveDependencies(this.getBoolean((Map<String, Object>)object2, "resolveTransitiveDependencies"));
                this.fetchExcludedTransitiveDependencies((Map<String, Object>)object2).forEach(builder::excludeTransitiveDependency);
                this.fetchRepositories((Map<String, Object>)object2).forEach(builder::repository);
                object2 = this.fetchRelocations((Map<String, Object>)object2);
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Relocation relocation = object2.next();
                    builder.relocate(relocation);
                }
                for (Relocation relocation : set) {
                    builder.relocate(relocation);
                }
                arrayList.add(builder.build());
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    private boolean getBoolean(@NotNull Map<String, Object> map, @NotNull String string) {
        return (Boolean)this.jsonObjectGetBoolean.invoke(map, string);
    }

    @Nullable
    private String getString(@NotNull Map<String, Object> map, @NotNull String string) {
        return (String)this.jsonObjectGetString.invoke(map, string);
    }

    @Nullable
    private ArrayList<Object> getArray(@NotNull Map<String, Object> map, @NotNull String string) {
        return (ArrayList)this.jsonObjectGetArray.invoke(map, string);
    }

    @Nullable
    private Map<String, Object> getObject(@NotNull ArrayList<Object> arrayList, int n2) {
        return (Map)this.jsonArrayGetObject.invoke(arrayList, n2);
    }
}

