/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.classloader;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.Util;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.logging.Logger;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public abstract class ClassLoaderHelper {
    public static final String SYSTEM_PROPERTY_DISABLE_UNSAFE = "libby.classloaders.unsafeDisabled";
    public static final String SYSTEM_PROPERTY_DISABLE_JAVA_AGENT = "libby.classloaders.javaAgentDisabled";
    public static final String ENV_VAR_DISABLE_UNSAFE = "LIBBY_CLASSLOADERS_UNSAFE_DISABLED";
    public static final String ENV_VAR_DISABLE_JAVA_AGENT = "LIBBY_CLASSLOADERS_JAVA_AGENT_DISABLED";
    private static final String BYTE_BUDDY_AGENT_CLASS = Util.replaceWithDots("net{}bytebuddy{}agent{}ByteBuddyAgent");
    private static final Method getModuleMethod;
    private static final Method addOpensMethod;
    private static final Method getNameMethod;
    private static final Unsafe theUnsafe;
    private static volatile Instrumentation cachedInstrumentation;
    protected final ClassLoader classLoader;

    public ClassLoaderHelper(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
    }

    public abstract void addToClasspath(@NotNull URL var1);

    public void addToClasspath(@NotNull Path path) {
        try {
            this.addToClasspath(Objects.requireNonNull(path, "path").toUri().toURL());
            return;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    protected void setMethodAccessible(LibraryManager object, Method method, String string, Consumer<MethodHandle> object2, Consumer<Instrumentation> object3) {
        if (Modifier.isPublic(method.getModifiers())) {
            return;
        }
        try {
            ClassLoaderHelper.openModule(method.getDeclaringClass());
        }
        catch (Exception exception) {}
        try {
            method.setAccessible(true);
            return;
        }
        catch (Exception exception) {
            Exception exception2;
            Exception exception3;
            block20: {
                block19: {
                    this.handleInaccessibleObjectException(exception, string);
                    exception3 = null;
                    if (theUnsafe != null && this.canUseUnsafe()) {
                        MethodHandle methodHandle;
                        try {
                            methodHandle = this.getPrivilegedMethodHandle(method).bindTo(this.classLoader);
                        }
                        catch (Exception exception4) {
                            object2 = exception4;
                            exception3 = exception4;
                            break block19;
                        }
                        object2.accept(methodHandle);
                        return;
                    }
                }
                exception2 = null;
                if (this.canUseJavaAgent()) {
                    try {
                        object2 = this.initInstrumentation((LibraryManager)object);
                    }
                    catch (Exception exception5) {
                        object3 = exception5;
                        exception2 = exception5;
                        break block20;
                    }
                    try {
                        object3.accept(object2);
                        return;
                    }
                    catch (Exception exception6) {
                        this.handleInaccessibleObjectException(exception6, string);
                    }
                }
            }
            object2 = ((LibraryManager)object).getLogger();
            if (exception3 != null) {
                ((Logger)object2).error("Cannot set accessible " + string + " using unsafe", exception3);
            }
            if (exception2 != null) {
                ((Logger)object2).error("Cannot set accessible " + string + " using java agent", exception2);
            }
            object3 = method.getDeclaringClass().getPackage().getName();
            object = null;
            try {
                object = (String)getNameMethod.invoke(getModuleMethod.invoke(method.getDeclaringClass(), new Object[0]), new Object[0]);
            }
            catch (Exception exception7) {}
            if (object != null) {
                ((Logger)object2).error("Cannot set accessible " + string + ", if you are using Java 9+ try to add the following option to your java command: --add-opens " + (String)object + "/" + (String)object3 + "=ALL-UNNAMED");
            } else {
                ((Logger)object2).error("Cannot set accessible " + string);
            }
            throw new RuntimeException("Cannot set accessible " + string);
        }
    }

    private void handleInaccessibleObjectException(Exception exception, String string) {
        if (!exception.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
            throw new RuntimeException("Cannot set accessible " + string, exception);
        }
    }

    protected static void openModule(Class<?> clazz) {
        Object object = getModuleMethod.invoke(clazz, new Object[0]);
        Object object2 = getModuleMethod.invoke(ClassLoaderHelper.class, new Object[0]);
        addOpensMethod.invoke(object, clazz.getPackage().getName(), object2);
    }

    protected MethodHandle getPrivilegedMethodHandle(Method method) {
        for (Field object : MethodHandles.Lookup.class.getDeclaredFields()) {
            if (object.getType() != MethodHandles.Lookup.class || !Modifier.isStatic(object.getModifiers()) || object.isSynthetic()) continue;
            try {
                Unsafe unsafe = theUnsafe;
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(object), theUnsafe.staticFieldOffset(object));
                return lookup.unreflect(method);
            }
            catch (Exception exception) {}
        }
        throw new RuntimeException("Cannot get privileged method handle.");
    }

    protected Instrumentation initInstrumentation(LibraryManager object) {
        Object object2 = cachedInstrumentation;
        if (object2 != null) {
            return object2;
        }
        object2 = new IsolatedClassLoader(new URL[0]);
        try {
            ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("net{}bytebuddy").artifactId("byte-buddy-agent").version("1.12.1").checksumFromBase64("mcCtBT9cljUEniB5ESpPDYZMfVxEs1JRPllOiWTP+bM=").repository("https://repo1.maven.org/maven2/").build()));
            object = ((ClassLoader)object2).loadClass(BYTE_BUDDY_AGENT_CLASS);
            object = (Instrumentation)((Class)object).getMethod("install", new Class[0]).invoke(null, new Object[0]);
            cachedInstrumentation = object;
        }
        catch (Throwable throwable) {
            try {
                ((URLClassLoader)object2).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((URLClassLoader)object2).close();
        }
        catch (Exception exception) {}
        return object;
    }

    protected boolean canUseUnsafe() {
        return !Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_DISABLE_UNSAFE)) && !Boolean.parseBoolean(System.getenv(ENV_VAR_DISABLE_UNSAFE));
    }

    protected boolean canUseJavaAgent() {
        return !Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_DISABLE_JAVA_AGENT)) && !Boolean.parseBoolean(System.getenv(ENV_VAR_DISABLE_JAVA_AGENT));
    }

    static {
        Object object = null;
        Object object2 = null;
        try {
            Class<?> clazz = Class.forName("java.lang.Module");
            object = Class.class.getMethod("getModule", new Class[0]);
            Method method = clazz.getMethod("addOpens", String.class, clazz);
            Method method2 = clazz.getMethod("getName", new Class[0]);
            getModuleMethod = object;
            addOpensMethod = method;
            getNameMethod = method2;
        }
        catch (Exception exception) {
            getModuleMethod = object;
            addOpensMethod = object2;
            getNameMethod = null;
        }
        catch (Throwable throwable) {
            getModuleMethod = object;
            addOpensMethod = object2;
            getNameMethod = null;
            throw throwable;
        }
        object = null;
        for (Field field : Unsafe.class.getDeclaredFields()) {
            try {
                if (field.getType() != Unsafe.class || !Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                object = (Unsafe)field.get(null);
            }
            catch (Exception exception) {}
        }
        theUnsafe = object;
    }
}

