/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.classloader.URLClassLoaderHelper;
import me.extremall.advancedkits.libs.libby.logging.adapters.JDKLogAdapter;
import me.extremall.advancedkits.libs.libby.logging.adapters.LogAdapter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PaperLibraryManager
extends LibraryManager {
    @NotNull
    private final URLClassLoaderHelper classLoader;
    @NotNull
    private final Plugin plugin;

    public PaperLibraryManager(@NotNull Plugin plugin) {
        this(plugin, "lib");
    }

    public PaperLibraryManager(@NotNull Plugin plugin, @NotNull String string) {
        this(plugin, string, new JDKLogAdapter(Objects.requireNonNull(plugin, "plugin").getLogger()));
    }

    public PaperLibraryManager(@NotNull Plugin plugin, @NotNull String object, @NotNull LogAdapter object2) {
        super((LogAdapter)object2, plugin.getDataFolder().toPath(), (String)object);
        object = plugin.getClass().getClassLoader();
        try {
            object2 = Class.forName("io.papermc.paper.plugin.entrypoint.classloader.PaperPluginClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getLogger().error("PaperPluginClassLoader not found, are you using Paper 1.19.3+?");
            throw new RuntimeException(classNotFoundException);
        }
        if (!((Class)object2).isAssignableFrom(object.getClass())) {
            throw new RuntimeException("Plugin classloader is not a PaperPluginClassLoader, are you using paper-plugin.yml?");
        }
        try {
            object2 = ((Class)object2).getDeclaredField("libraryLoader");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.getLogger().error("Cannot find libraryLoader field in PaperPluginClassLoader, please open a bug report.");
            throw new RuntimeException(noSuchFieldException);
        }
        ((Field)object2).setAccessible(true);
        try {
            object = (URLClassLoader)((Field)object2).get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        this.classLoader = new URLClassLoaderHelper((URLClassLoader)object, this);
        this.plugin = plugin;
    }

    @Override
    protected void addToClasspath(@NotNull Path path) {
        this.classLoader.addToClasspath(path);
    }

    @Override
    protected InputStream getResourceAsStream(@NotNull String string) {
        return this.plugin.getResource(string);
    }
}

