/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.RepositoryResolutionMode;
import me.extremall.advancedkits.libs.libby.Util;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.configuration.Configuration;
import me.extremall.advancedkits.libs.libby.configuration.ConfigurationFetcher;
import me.extremall.advancedkits.libs.libby.logging.LogLevel;
import me.extremall.advancedkits.libs.libby.logging.Logger;
import me.extremall.advancedkits.libs.libby.logging.adapters.LogAdapter;
import me.extremall.advancedkits.libs.libby.relocation.Relocation;
import me.extremall.advancedkits.libs.libby.relocation.RelocationHelper;
import me.extremall.advancedkits.libs.libby.transitive.TransitiveDependencyHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class LibraryManager {
    protected final Logger logger;
    protected final Path saveDirectory;
    protected final Set<String> repositories = new LinkedHashSet<String>();
    protected RelocationHelper relocator;
    protected TransitiveDependencyHelper transitiveDependencyHelper;
    protected ConfigurationFetcher configurationFetcher;
    protected final IsolatedClassLoader globalIsolatedClassLoader = new IsolatedClassLoader(new URL[0]);
    protected final Map<String, IsolatedClassLoader> isolatedLibraries = new HashMap<String, IsolatedClassLoader>();
    protected RepositoryResolutionMode repositoryResolutionMode = RepositoryResolutionMode.DEFAULT;

    @Deprecated
    protected LibraryManager(@NotNull LogAdapter logAdapter, @NotNull Path path) {
        this.logger = new Logger(Objects.requireNonNull(logAdapter, "logAdapter"));
        this.saveDirectory = Objects.requireNonNull(path, "dataDirectory").toAbsolutePath().resolve("lib");
    }

    protected LibraryManager(@NotNull LogAdapter logAdapter, @NotNull Path path, @NotNull String string) {
        this.logger = new Logger(Objects.requireNonNull(logAdapter, "logAdapter"));
        this.saveDirectory = Objects.requireNonNull(path, "dataDirectory").toAbsolutePath().resolve(Objects.requireNonNull(string, "directoryName"));
    }

    protected abstract void addToClasspath(@NotNull Path var1);

    protected void addToIsolatedClasspath(@NotNull Library object, @NotNull Path path) {
        object = (object = ((Library)object).getLoaderId()) != null ? this.isolatedLibraries.computeIfAbsent((String)object, string -> new IsolatedClassLoader(new URL[0])) : this.globalIsolatedClassLoader;
        ((IsolatedClassLoader)object).addPath(path);
    }

    @NotNull
    public IsolatedClassLoader getGlobalIsolatedClassLoader() {
        return this.globalIsolatedClassLoader;
    }

    @Nullable
    public IsolatedClassLoader getIsolatedClassLoaderById(@NotNull String string) {
        return this.isolatedLibraries.get(string);
    }

    @NotNull
    public LogLevel getLogLevel() {
        return this.logger.getLevel();
    }

    public void setLogLevel(@NotNull LogLevel logLevel) {
        this.logger.setLevel(logLevel);
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public Collection<String> getRepositories() {
        LinkedList<String> linkedList;
        Set<String> set = this.repositories;
        synchronized (set) {
            linkedList = new LinkedList<String>(this.repositories);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public void addRepository(@NotNull String string) {
        string = Objects.requireNonNull(string, "url").endsWith("/") ? string : string + '/';
        Set<String> set = this.repositories;
        synchronized (set) {
            this.repositories.add(string);
            return;
        }
    }

    public void addMavenLocal() {
        this.addRepository(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/repository").toUri().toString());
    }

    public void addMavenCentral() {
        this.addRepository("https://repo1.maven.org/maven2/");
    }

    public void addSonatype() {
        this.addRepository("https://oss.sonatype.org/content/groups/public/");
    }

    public void addJCenter() {
        this.addRepository("https://jcenter.bintray.com/");
    }

    public void addJitPack() {
        this.addRepository("https://jitpack.io/");
    }

    public RepositoryResolutionMode getRepositoryResolutionMode() {
        return this.repositoryResolutionMode;
    }

    public void setRepositoryResolutionMode(RepositoryResolutionMode repositoryResolutionMode) {
        this.repositoryResolutionMode = repositoryResolutionMode;
    }

    @NotNull
    public Collection<String> resolveLibrary(@NotNull Library library) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Objects.requireNonNull(library, "library").getUrls());
        boolean bl2 = library.isSnapshot();
        Object object = this.resolveRepositories(library);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (bl2) {
                String string2 = this.resolveSnapshot(string, library);
                if (string2 == null) continue;
                linkedHashSet.add(string + string2);
                continue;
            }
            linkedHashSet.add(string + library.getPath());
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    protected Collection<String> resolveRepositories(@NotNull Library library) {
        switch (this.getRepositoryResolutionMode()) {
            case GLOBAL_FIRST: {
                return Stream.of(this.getRepositories(), library.getRepositories(), library.getFallbackRepositories()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            case LIBRARY_FIRST: {
                return Stream.of(library.getRepositories(), library.getFallbackRepositories(), this.getRepositories()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        return Stream.of(library.getRepositories(), this.getRepositories(), library.getFallbackRepositories()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Nullable
    protected String resolveSnapshot(@NotNull String string, @NotNull Library object) {
        block15: {
            Object object2 = string.startsWith("file") ? "maven-metadata-local.xml" : "maven-metadata.xml";
            string = Objects.requireNonNull(string, "repository") + Objects.requireNonNull(object, "library").getPartialPath() + (String)object2;
            object2 = new URL(Objects.requireNonNull(string, "url")).openConnection();
            ((URLConnection)object2).setConnectTimeout(5000);
            ((URLConnection)object2).setReadTimeout(5000);
            ((URLConnection)object2).setRequestProperty("User-Agent", "libby/2.0.0-SNAPSHOT");
            object2 = ((URLConnection)object2).getInputStream();
            try {
                object = this.getURLFromMetadata((InputStream)object2, (Library)object);
                if (object2 == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (object2 != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException(malformedURLException);
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    if (iOException instanceof FileNotFoundException) {
                        this.logger.debug("File not found: " + string);
                    } else if (object2 instanceof SocketTimeoutException) {
                        this.logger.debug("Connect timed out: " + string);
                    } else if (object2 instanceof UnknownHostException) {
                        this.logger.debug("Unknown host: " + string);
                    } else {
                        this.logger.debug("Unexpected IOException", (Throwable)object2);
                    }
                    return null;
                }
            }
            ((InputStream)object2).close();
        }
        return object;
    }

    @Nullable
    protected String getURLFromMetadata(@NotNull InputStream object, @NotNull Library library) {
        Objects.requireNonNull(object, "inputStream");
        Objects.requireNonNull(library, "library");
        Object object2 = library.getVersion();
        try {
            Object object3 = DocumentBuilderFactory.newInstance();
            object3 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            object = ((DocumentBuilder)object3).parse((InputStream)object);
            object.getDocumentElement().normalize();
            object = object.getElementsByTagName("snapshot");
            if (object.getLength() == 0) {
                return null;
            }
            if ((object = object.item(0)).getNodeType() != 1) {
                return null;
            }
            object3 = ((Element)object).getElementsByTagName("localCopy").item(0);
            if (object3 == null || object3.getNodeType() != 1) {
                object2 = ((Element)object).getElementsByTagName("timestamp").item(0);
                if (object2 == null || object2.getNodeType() != 1) {
                    return null;
                }
                if ((object = ((Element)object).getElementsByTagName("buildNumber").item(0)) == null || object.getNodeType() != 1) {
                    return null;
                }
                if ((object2 = object2.getFirstChild()) == null || object2.getNodeType() != 3) {
                    return null;
                }
                if ((object = object.getFirstChild()) == null || object.getNodeType() != 3) {
                    return null;
                }
                object3 = object2.getNodeValue();
                object = object.getNodeValue();
                object2 = library.getVersion();
                if (((String)object2).endsWith("-SNAPSHOT")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 9);
                }
                object2 = (String)object2 + '-' + (String)object3 + '-' + (String)object;
            }
        }
        catch (ParserConfigurationException | SAXException exception) {
            this.logger.debug("Invalid maven-metadata.xml", exception);
            return null;
        }
        return Util.craftPath(library.getPartialPath(), library.getArtifactId(), (String)object2, library.getClassifier());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] downloadLibrary(@NotNull String string) {
        try {
            Object object = new URL(Objects.requireNonNull(string, "url")).openConnection();
            ((URLConnection)object).setConnectTimeout(5000);
            ((URLConnection)object).setReadTimeout(5000);
            ((URLConnection)object).setRequestProperty("User-Agent", "libby/2.0.0-SNAPSHOT");
            InputStream inputStream = ((URLConnection)object).getInputStream();
            try {
                byte[] throwable2 = new byte[8192];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    int throwable;
                    while ((throwable = inputStream.read(throwable2)) != -1) {
                        byteArrayOutputStream.write(throwable2, 0, throwable);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.logger.warn("Download timed out: " + ((URLConnection)object).getURL());
                    if (inputStream == null) return null;
                    inputStream.close();
                    return null;
                }
                this.logger.info("Downloaded library " + ((URLConnection)object).getURL());
                object = byteArrayOutputStream.toByteArray();
                return object;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            if (iOException instanceof FileNotFoundException) {
                this.logger.debug("File not found: " + string);
                return null;
            }
            if (iOException2 instanceof SocketTimeoutException) {
                this.logger.debug("Connect timed out: " + string);
                return null;
            }
            if (iOException2 instanceof UnknownHostException) {
                this.logger.debug("Unknown host: " + string);
                return null;
            }
            this.logger.debug("Unexpected IOException", iOException2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Path downloadLibrary(@NotNull Library library) {
        Path path;
        block22: {
            Object object;
            block21: {
                Object object2;
                Path path2 = this.saveDirectory.resolve(Objects.requireNonNull(library, "library").getPath());
                if (Files.exists(path2, new LinkOption[0])) {
                    if (!library.isSnapshot()) {
                        if (!library.hasRelocations()) return path2;
                        return this.relocate(path2, library.getRelocatedPath(), library.getRelocations());
                    }
                    try {
                        Files.delete(path2);
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                }
                if ((object2 = this.resolveLibrary(library)).isEmpty()) {
                    throw new RuntimeException("Library '" + library + "' couldn't be resolved, add a repository");
                }
                MessageDigest messageDigest = null;
                if (library.hasChecksum()) {
                    try {
                        messageDigest = MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new RuntimeException(noSuchAlgorithmException);
                    }
                }
                path = path2.resolveSibling(path2.getFileName() + ".tmp");
                path.toFile().deleteOnExit();
                try {
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        String string = (String)object2.next();
                        byte[] byArray = this.downloadLibrary(string);
                        if (byArray == null) continue;
                        if (messageDigest != null && !Arrays.equals(object = messageDigest.digest(byArray), library.getChecksum())) {
                            this.logger.warn("*** INVALID CHECKSUM ***");
                            this.logger.warn(" Library :  " + library);
                            this.logger.warn(" URL :  " + string);
                            this.logger.warn(" Expected :  " + Base64.getEncoder().encodeToString(library.getChecksum()));
                            this.logger.warn(" Actual :  " + Base64.getEncoder().encodeToString((byte[])object));
                            continue;
                        }
                        Files.write(path, byArray, new OpenOption[0]);
                        Files.move(path, path2, new CopyOption[0]);
                        if (library.hasRelocations()) {
                            path2 = this.relocate(path2, library.getRelocatedPath(), library.getRelocations());
                        }
                        object = path2;
                        break block21;
                    }
                    break block22;
                }
                catch (IOException iOException) {
                    try {
                        throw new UncheckedIOException(iOException);
                    }
                    catch (Throwable throwable) {
                        try {
                            Files.deleteIfExists(path);
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
            }
            try {
                Files.deleteIfExists(path);
                return object;
            }
            catch (IOException iOException) {}
            return object;
        }
        try {
            Files.deleteIfExists(path);
            throw new RuntimeException("Failed to download library '" + library + "'");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to download library '" + library + "'");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Path relocate(@NotNull Path path, @NotNull String object, @NotNull Collection<Relocation> collection) {
        void var3_4;
        Path path2;
        Objects.requireNonNull(path, "in");
        Objects.requireNonNull(path2, "out");
        Objects.requireNonNull(var3_4, "relocations");
        path2 = this.saveDirectory.resolve((String)((Object)path2));
        if (Files.exists(path2, new LinkOption[0])) {
            return path2;
        }
        Path path3 = path2.resolveSibling(path2.getFileName() + ".tmp");
        path3.toFile().deleteOnExit();
        Object object2 = this;
        synchronized (object2) {
            if (this.relocator == null) {
                this.relocator = new RelocationHelper(this);
            }
        }
        try {
            this.relocator.relocate(path, path3, (Collection<Relocation>)var3_4);
            Files.move(path3, path2, new CopyOption[0]);
            this.logger.info("Relocations applied to " + path.getFileName());
            object2 = path2;
        }
        catch (IOException object22) {
            try {
                throw new UncheckedIOException(object22);
            }
            catch (Throwable throwable) {
                try {
                    Files.deleteIfExists(path3);
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            Files.deleteIfExists(path3);
            return object2;
        }
        catch (IOException iOException) {}
        return object2;
    }

    protected void resolveTransitiveLibraries(@NotNull Library library2) {
        Objects.requireNonNull(library2, "library");
        LibraryManager libraryManager = this;
        synchronized (libraryManager) {
            if (this.transitiveDependencyHelper == null) {
                LibraryManager libraryManager2 = this;
                this.transitiveDependencyHelper = new TransitiveDependencyHelper(libraryManager2, libraryManager2.saveDirectory);
            }
        }
        for (Library library2 : this.transitiveDependencyHelper.findTransitiveLibraries(library2)) {
            this.loadLibrary(library2);
        }
    }

    public void loadLibrary(@NotNull Library library) {
        this.logger.info("Loading library " + library.getArtifactId());
        Path path = this.downloadLibrary(Objects.requireNonNull(library, "library"));
        if (library.resolveTransitiveDependencies()) {
            this.resolveTransitiveLibraries(library);
        }
        if (library.isIsolatedLoad()) {
            this.addToIsolatedClasspath(library, path);
            return;
        }
        this.addToClasspath(path);
    }

    public void loadLibraries(Library ... libraryArray) {
        for (Library library : libraryArray) {
            this.loadLibrary(library);
        }
    }

    public void configureFromJSON() {
        this.configureFromJSON("libby.json");
    }

    public void configureFromJSON(@NotNull String string) {
        LibraryManager libraryManager = this;
        libraryManager.configureFromJSON(Objects.requireNonNull(libraryManager.getResourceAsStream(string), "resourceAsStream"));
    }

    public void configureFromJSON(@NotNull InputStream iterator) {
        Object object = this;
        synchronized (object) {
            if (this.configurationFetcher == null) {
                this.configurationFetcher = new ConfigurationFetcher(this);
            }
        }
        object = this.configurationFetcher.readJsonFile((InputStream)((Object)iterator));
        for (String object2 : ((Configuration)object).getRepositories()) {
            this.addRepository(object2);
        }
        for (Library library : ((Configuration)object).getLibraries()) {
            this.loadLibrary(library);
        }
    }

    @Nullable
    protected InputStream getResourceAsStream(@NotNull String string) {
        return this.getClass().getClassLoader().getResourceAsStream(string);
    }
}

