/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.bstats.json;

import java.util.Arrays;
import java.util.stream.Collectors;

public class JsonObjectBuilder {
    private StringBuilder builder = new StringBuilder();
    private boolean hasAtLeastOneField = false;

    public JsonObjectBuilder() {
        this.builder.append("{");
    }

    public JsonObjectBuilder appendNull(String string) {
        this.appendFieldUnescaped(string, "null");
        return this;
    }

    public JsonObjectBuilder appendField(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("JSON value must not be null");
        }
        this.appendFieldUnescaped(string, "\"" + JsonObjectBuilder.escape(string2) + "\"");
        return this;
    }

    public JsonObjectBuilder appendField(String string, int n2) {
        this.appendFieldUnescaped(string, String.valueOf(n2));
        return this;
    }

    public JsonObjectBuilder appendField(String string, JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("JSON object must not be null");
        }
        this.appendFieldUnescaped(string, jsonObject.toString());
        return this;
    }

    public JsonObjectBuilder appendField(String string2, String[] object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        object = Arrays.stream(object).map(string -> "\"" + JsonObjectBuilder.escape(string) + "\"").collect(Collectors.joining(","));
        this.appendFieldUnescaped(string2, "[" + (String)object + "]");
        return this;
    }

    public JsonObjectBuilder appendField(String string, int[] object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        object = Arrays.stream(object).mapToObj(String::valueOf).collect(Collectors.joining(","));
        this.appendFieldUnescaped(string, "[" + (String)object + "]");
        return this;
    }

    public JsonObjectBuilder appendField(String string, JsonObject[] object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        object = Arrays.stream(object).map(JsonObject::toString).collect(Collectors.joining(","));
        this.appendFieldUnescaped(string, "[" + (String)object + "]");
        return this;
    }

    private void appendFieldUnescaped(String string, String string2) {
        if (this.builder == null) {
            throw new IllegalStateException("JSON has already been built");
        }
        if (string == null) {
            throw new IllegalArgumentException("JSON key must not be null");
        }
        if (this.hasAtLeastOneField) {
            this.builder.append(",");
        }
        this.builder.append("\"").append(JsonObjectBuilder.escape(string)).append("\":").append(string2);
        this.hasAtLeastOneField = true;
    }

    public JsonObject build() {
        if (this.builder == null) {
            throw new IllegalStateException("JSON has already been built");
        }
        JsonObject jsonObject = new JsonObject(this.builder.append("}").toString());
        this.builder = null;
        return jsonObject;
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c2 == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c2 <= '\u000f') {
                stringBuilder.append("\\u000").append(Integer.toHexString(c2));
                continue;
            }
            if (c2 <= '\u001f') {
                stringBuilder.append("\\u00").append(Integer.toHexString(c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static class JsonObject {
        private final String value;

        private JsonObject(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

