/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.bstats.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MetricsConfig {
    private final File file;
    private final boolean defaultEnabled;
    private String serverUUID;
    private boolean enabled;
    private boolean logErrors;
    private boolean logSentData;
    private boolean logResponseStatusText;
    private boolean didExistBefore = true;

    public MetricsConfig(File file, boolean bl2) {
        this.file = file;
        this.defaultEnabled = bl2;
        this.setupConfig();
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLogErrorsEnabled() {
        return this.logErrors;
    }

    public boolean isLogSentDataEnabled() {
        return this.logSentData;
    }

    public boolean isLogResponseStatusTextEnabled() {
        return this.logResponseStatusText;
    }

    public boolean didExistBefore() {
        return this.didExistBefore;
    }

    private void setupConfig() {
        if (!this.file.exists()) {
            this.didExistBefore = false;
            this.writeConfig();
        }
        this.readConfig();
        if (this.serverUUID == null) {
            this.writeConfig();
            this.readConfig();
        }
    }

    private void writeConfig() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("# bStats (https://bStats.org) collects some basic information for plugin authors, like");
        arrayList.add("# how many people use their plugin and their total player count. It's recommended to keep");
        arrayList.add("# bStats enabled, but if you're not comfortable with this, you can turn this setting off.");
        arrayList.add("# There is no performance penalty associated with having metrics enabled, and data sent to");
        arrayList.add("# bStats is fully anonymous.");
        arrayList.add("enabled=" + this.defaultEnabled);
        arrayList.add("server-uuid=" + UUID.randomUUID().toString());
        arrayList.add("log-errors=false");
        arrayList.add("log-sent-data=false");
        arrayList.add("log-response-status-text=false");
        MetricsConfig metricsConfig = this;
        metricsConfig.writeFile(metricsConfig.file, arrayList);
    }

    private void readConfig() {
        MetricsConfig metricsConfig = this;
        List<String> list = metricsConfig.readFile(metricsConfig.file);
        if (list == null) {
            throw new AssertionError((Object)"Content of newly created file is null");
        }
        this.enabled = this.getConfigValue("enabled", list).map("true"::equals).orElse(Boolean.TRUE);
        this.serverUUID = this.getConfigValue("server-uuid", list).orElse(null);
        this.logErrors = this.getConfigValue("log-errors", list).map("true"::equals).orElse(Boolean.FALSE);
        this.logSentData = this.getConfigValue("log-sent-data", list).map("true"::equals).orElse(Boolean.FALSE);
        this.logResponseStatusText = this.getConfigValue("log-response-status-text", list).map("true"::equals).orElse(Boolean.FALSE);
    }

    private Optional<String> getConfigValue(String string, List<String> list) {
        return list.stream().filter(string2 -> string2.startsWith(string + "=")).map(string2 -> string2.replaceFirst(Pattern.quote(string + "="), "")).findFirst();
    }

    private List<String> readFile(File object) {
        if (!((File)object).exists()) {
            return null;
        }
        object = new FileReader((File)object);
        try {
            List<String> list;
            try (BufferedReader bufferedReader = new BufferedReader((Reader)object);){
                list = bufferedReader.lines().collect(Collectors.toList());
            }
            return list;
        }
        finally {
            ((InputStreamReader)object).close();
        }
    }

    private void writeFile(File object, List<String> object2) {
        if (!((File)object).exists()) {
            ((File)object).getParentFile().mkdirs();
            ((File)object).createNewFile();
        }
        object = new FileWriter((File)object);
        try {
            try (BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);){
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
            }
            return;
        }
        finally {
            ((OutputStreamWriter)object).close();
        }
    }
}

