/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util.transform;

import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public interface TransformStack {
    public static final Vector3d CENTER = new Vector3d(0.5, 0.5, 0.5);

    public TransformStack translate(double var1, double var3, double var5);

    public TransformStack multiply(Quaternion var1);

    public TransformStack scale(float var1);

    public TransformStack push();

    public TransformStack pop();

    default public TransformStack rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        return this.multiply(axis.func_229386_k_().func_229193_c_(radians));
    }

    default public TransformStack rotate(double angle, Direction.Axis axis) {
        Vector3f vec = axis == Direction.Axis.X ? Vector3f.field_229179_b_ : (axis == Direction.Axis.Y ? Vector3f.field_229181_d_ : Vector3f.field_229183_f_);
        return this.multiply(vec, angle);
    }

    default public TransformStack rotateX(double angle) {
        return this.multiply(Vector3f.field_229179_b_, angle);
    }

    default public TransformStack rotateY(double angle) {
        return this.multiply(Vector3f.field_229181_d_, angle);
    }

    default public TransformStack rotateZ(double angle) {
        return this.multiply(Vector3f.field_229183_f_, angle);
    }

    default public TransformStack centre() {
        return this.translateAll(0.5);
    }

    default public TransformStack unCentre() {
        return this.translateAll(-0.5);
    }

    default public TransformStack translateAll(double v) {
        return this.translate(v, v, v);
    }

    default public TransformStack translateX(double x) {
        return this.translate(x, 0.0, 0.0);
    }

    default public TransformStack translateY(double y) {
        return this.translate(0.0, y, 0.0);
    }

    default public TransformStack translateZ(double z) {
        return this.translate(0.0, 0.0, z);
    }

    default public TransformStack translate(Vector3i vec) {
        return this.translate(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    default public TransformStack translate(Vector3d vec) {
        return this.translate(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    default public TransformStack translateBack(Vector3d vec) {
        return this.translate(-vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
    }

    default public TransformStack nudge(int id) {
        long randomBits = (long)id * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yNudge = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zNudge = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        return this.translate(xNudge, yNudge, zNudge);
    }

    default public TransformStack multiply(Vector3f axis, double angle) {
        if (angle == 0.0) {
            return this;
        }
        return this.multiply(axis.func_229187_a_((float)angle));
    }
}

