/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.pipeline;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.pipeline.GLSLVersion;
import com.jozufozu.flywheel.backend.pipeline.ShaderBuilder;
import com.jozufozu.flywheel.backend.pipeline.SourceFile;
import com.jozufozu.flywheel.backend.pipeline.Template;
import com.jozufozu.flywheel.core.shader.ExtensibleGlProgram;
import com.jozufozu.flywheel.core.shader.GameStateProgram;
import com.jozufozu.flywheel.core.shader.IMultiProgram;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import com.jozufozu.flywheel.core.shader.spec.ProgramState;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class WorldShaderPipeline<P extends WorldProgram> {
    private final ShaderSources sources;
    private final ExtensibleGlProgram.Factory<P> factory;

    public WorldShaderPipeline(ShaderSources sources, ExtensibleGlProgram.Factory<P> factory) {
        this.sources = sources;
        this.factory = factory;
    }

    public IMultiProgram<P> compile(ProgramSpec spec) {
        SourceFile file = this.sources.source(spec.vert);
        return this.compile(spec.name, file, spec.getStates());
    }

    public IMultiProgram<P> compile(ResourceLocation name, SourceFile file, List<ProgramState> variants) {
        ShaderBuilder shader = new ShaderBuilder(name, new Template()).setMainSource(file).setVersion(GLSLVersion.V120);
        GameStateProgram.Builder<P> builder = GameStateProgram.builder(this.compile(shader, name, null));
        for (ProgramState variant : variants) {
            builder.withVariant(variant.getContext(), this.compile(shader, name, variant));
        }
        return builder.build();
    }

    private P compile(ShaderBuilder shader, ResourceLocation name, @Nullable ProgramState variant) {
        int result;
        if (variant != null) {
            shader.setDefines(variant.getDefines());
        }
        GlShader vertex = shader.compile(name, ShaderType.VERTEX);
        GlShader fragment = shader.compile(name, ShaderType.FRAGMENT);
        int program = GL20.glCreateProgram();
        GL20.glAttachShader((int)program, (int)vertex.handle());
        GL20.glAttachShader((int)program, (int)fragment.handle());
        String log = GL20.glGetProgramInfoLog((int)program);
        if (!log.isEmpty()) {
            Backend.log.debug("Program link log for " + name + ": " + log);
        }
        if ((result = GL20.glGetProgrami((int)program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        if (variant != null) {
            return (P)((WorldProgram)this.factory.create(name, program, variant.getExtensions()));
        }
        return (P)((WorldProgram)this.factory.create(name, program, null));
    }
}

