/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.pipeline;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.backend.loading.ProgramTemplate;
import com.jozufozu.flywheel.backend.loading.Shader;
import com.jozufozu.flywheel.backend.loading.ShaderTransformer;
import com.jozufozu.flywheel.backend.pipeline.IShaderPipeline;
import com.jozufozu.flywheel.core.shader.ExtensibleGlProgram;
import com.jozufozu.flywheel.core.shader.GameStateProgram;
import com.jozufozu.flywheel.core.shader.IMultiProgram;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import com.jozufozu.flywheel.core.shader.spec.ProgramState;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class LegacyPipeline<P extends WorldProgram>
implements IShaderPipeline<P> {
    private final ShaderSources sources;
    private final ExtensibleGlProgram.Factory<P> factory;
    private final ProgramTemplate template;
    protected final ShaderTransformer transformer;

    public LegacyPipeline(Builder<P> builder) {
        this.sources = ((Builder)builder).sources;
        this.factory = ((Builder)builder).factory;
        this.transformer = builder.transformer;
        this.template = ((Builder)builder).template;
    }

    @Override
    public IMultiProgram<P> compile(ProgramSpec spec) {
        GameStateProgram.Builder<P> builder = GameStateProgram.builder(this.compile(spec, null));
        for (ProgramState state : spec.states) {
            builder.withVariant(state.getContext(), this.compile(spec, state));
        }
        return builder.build();
    }

    private P compile(ProgramSpec spec, @Nullable ProgramState state) {
        if (state != null) {
            Program program = this.loadAndLink(spec, state);
            return (P)((WorldProgram)this.factory.create(program.name, program.program, state.getExtensions()));
        }
        Program program = this.loadAndLink(spec, null);
        return (P)((WorldProgram)this.factory.create(program.name, program.program, null));
    }

    public Program loadAndLink(ProgramSpec spec, @Nullable ProgramState state) {
        Shader vertexFile = this.sources.source(spec.vert, ShaderType.VERTEX);
        Shader fragmentFile = this.sources.source(spec.frag, ShaderType.FRAGMENT);
        this.transformer.transformSource(vertexFile);
        this.transformer.transformSource(fragmentFile);
        if (state != null) {
            vertexFile.defineAll(state.getDefines());
            fragmentFile.defineAll(state.getDefines());
        }
        Program program = LegacyPipeline.buildProgram(vertexFile, fragmentFile);
        this.template.attachAttributes(program);
        program.link(spec.name).deleteLinkedShaders();
        String descriptor = program.program + ": " + spec.name;
        if (state != null) {
            descriptor = descriptor + "#" + state;
        }
        Backend.log.debug(descriptor);
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Program buildProgram(Shader ... shaders) {
        ArrayList<GlShader> compiled = new ArrayList<GlShader>(shaders.length);
        try {
            Program builder = new Program();
            for (Shader shader : shaders) {
                GlShader sh = new GlShader(shader.name, shader.type, (CharSequence)shader.getSource());
                compiled.add(sh);
                builder.attachShader(shader, sh);
            }
            Program program = builder;
            return program;
        }
        finally {
            compiled.forEach(GlObject::delete);
        }
    }

    public static <P extends WorldProgram> Builder<P> builder(ShaderSources sources, ExtensibleGlProgram.Factory<P> factory) {
        return new Builder<P>(sources, factory);
    }

    public static class Builder<P extends WorldProgram> {
        private final ShaderSources sources;
        private final ExtensibleGlProgram.Factory<P> factory;
        private ProgramTemplate template;
        protected ShaderTransformer transformer;

        public Builder(ShaderSources sources, ExtensibleGlProgram.Factory<P> factory) {
            this.sources = sources;
            this.factory = factory;
        }

        public Builder<P> setTemplate(ProgramTemplate template) {
            this.template = template;
            return this;
        }

        public Builder<P> setTransformer(ShaderTransformer transformer) {
            this.transformer = transformer;
            return this;
        }

        public LegacyPipeline<P> build() {
            return new LegacyPipeline(this);
        }
    }
}

