/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlPrimitive;
import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.model.IBufferedModel;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.util.AttribUtil;
import org.lwjgl.opengl.GL20;

public class BufferedModel
implements IBufferedModel {
    protected final IModel model;
    protected final GlPrimitive primitiveMode;
    protected GlBuffer vbo;
    protected boolean deleted;

    public BufferedModel(GlPrimitive primitiveMode, IModel model) {
        this.model = model;
        this.primitiveMode = primitiveMode;
        this.vbo = new GlBuffer(GlBufferType.ARRAY_BUFFER);
        this.vbo.bind();
        this.vbo.alloc(model.size());
        MappedBuffer buffer = this.vbo.getBuffer(0, model.size());
        model.buffer(buffer);
        buffer.flush();
        this.vbo.unbind();
    }

    @Override
    public VertexFormat getFormat() {
        return this.model.format();
    }

    @Override
    public int getVertexCount() {
        return this.model.vertexCount();
    }

    @Override
    public boolean valid() {
        return this.getVertexCount() > 0 && !this.deleted;
    }

    @Override
    public void setupState() {
        this.vbo.bind();
        AttribUtil.enableArrays(this.getAttributeCount());
        this.getFormat().vertexAttribPointers(0);
    }

    @Override
    public void clearState() {
        AttribUtil.disableArrays(this.getAttributeCount());
        this.vbo.unbind();
    }

    @Override
    public void drawCall() {
        GL20.glDrawArrays((int)this.primitiveMode.glEnum, (int)0, (int)this.getVertexCount());
    }

    @Override
    public void drawInstances(int instanceCount) {
        if (!this.valid()) {
            return;
        }
        Backend.getInstance().compat.drawInstanced.drawArraysInstanced(this.primitiveMode, 0, this.getVertexCount(), instanceCount);
    }

    @Override
    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        this.vbo.delete();
    }
}

