/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import net.minecraft.client.gui.AbstractGui;

public abstract class RenderElement
implements IScreenRenderable {
    public static RenderElement EMPTY = new RenderElement(){

        @Override
        public void render(MatrixStack ms) {
        }
    };
    protected int width = 16;
    protected int height = 16;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float z = 0.0f;
    protected float alpha = 1.0f;

    public static RenderElement of(IScreenRenderable renderable) {
        return new SimpleRenderElement(renderable);
    }

    public <T extends RenderElement> T at(float x, float y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    public <T extends RenderElement> T at(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return (T)this;
    }

    public <T extends RenderElement> T withBounds(int width, int height) {
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public <T extends RenderElement> T withAlpha(float alpha) {
        this.alpha = alpha;
        return (T)this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public abstract void render(MatrixStack var1);

    @Override
    public void draw(MatrixStack ms, AbstractGui screen, int x, int y) {
        ((RenderElement)this.at(x, y)).render(ms);
    }

    @Override
    public void draw(MatrixStack ms, int x, int y) {
        ((RenderElement)this.at(x, y)).render(ms);
    }

    public static class SimpleRenderElement
    extends RenderElement {
        private IScreenRenderable renderable;

        public SimpleRenderElement(IScreenRenderable renderable) {
            this.renderable = renderable;
        }

        @Override
        public void render(MatrixStack ms) {
            this.renderable.draw(ms, (int)this.x, (int)this.y);
        }
    }
}

