/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.FlapData;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.LightType;

public class FunnelInstance
extends TileEntityInstance<FunnelTileEntity>
implements IDynamicInstance {
    private final ArrayList<FlapData> flaps = new ArrayList(4);

    public FunnelInstance(MaterialManager<?> modelManager, FunnelTileEntity tile) {
        super(modelManager, (TileEntity)tile);
        if (!tile.hasFlap()) {
            return;
        }
        PartialModel flapPartial = this.blockState.func_177230_c() instanceof FunnelBlock ? AllBlockPartials.FUNNEL_FLAP : AllBlockPartials.BELT_FUNNEL_FLAP;
        Instancer model = modelManager.defaultSolid().material(AllMaterialSpecs.FLAPS).getModel(flapPartial, this.blockState);
        int blockLight = this.world.func_226658_a_(LightType.BLOCK, this.pos);
        int skyLight = this.world.func_226658_a_(LightType.SKY, this.pos);
        Direction direction = FunnelBlock.getFunnelFacing(this.blockState);
        float flapness = tile.flap.get(AnimationTickHolder.getPartialTicks());
        float horizontalAngle = direction.func_176734_d().func_185119_l();
        for (int segment = 0; segment <= 3; ++segment) {
            float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
            float segmentOffset = -0.1875f * (float)segment;
            FlapData key = (FlapData)model.createInstance();
            key.setPosition(this.getInstancePosition()).setSegmentOffset(segmentOffset, 0.0f, -tile.getFlapOffset()).setBlockLight(blockLight).setSkyLight(skyLight).setHorizontalAngle(horizontalAngle).setFlapness(flapness).setFlapScale(-1.0f).setPivotVoxelSpace(0.0f, 10.0f, 9.5f).setIntensity(intensity);
            this.flaps.add(key);
        }
    }

    public void beginFrame() {
        if (this.flaps == null) {
            return;
        }
        float flapness = ((FunnelTileEntity)this.tile).flap.get(AnimationTickHolder.getPartialTicks());
        for (FlapData flap : this.flaps) {
            flap.setFlapness(flapness);
        }
    }

    public void updateLight() {
        if (this.flaps != null) {
            this.relight(this.pos, this.flaps.stream());
        }
    }

    public void remove() {
        if (this.flaps == null) {
            return;
        }
        this.flaps.forEach(InstanceData::delete);
    }
}

