/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.content.curiosities.toolbox.ItemReturnInvWrapper;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolboxEquipPacket
extends SimplePacketBase {
    private BlockPos toolboxPos;
    private int slot;
    private int hotbarSlot;

    public ToolboxEquipPacket(BlockPos toolboxPos, int slot, int hotbarSlot) {
        this.toolboxPos = toolboxPos;
        this.slot = slot;
        this.hotbarSlot = hotbarSlot;
    }

    public ToolboxEquipPacket(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.toolboxPos = buffer.func_179259_c();
        }
        this.slot = buffer.func_150792_a();
        this.hotbarSlot = buffer.func_150792_a();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.toolboxPos != null);
        if (this.toolboxPos != null) {
            buffer.func_179255_a(this.toolboxPos);
        }
        buffer.func_150787_b(this.slot);
        buffer.func_150787_b(this.hotbarSlot);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            World world = player.field_70170_p;
            if (this.toolboxPos == null) {
                ToolboxHandler.unequip((PlayerEntity)player, this.hotbarSlot, false);
                ToolboxHandler.syncData((PlayerEntity)player);
                return;
            }
            TileEntity blockEntity = world.func_175625_s(this.toolboxPos);
            double maxRange = ToolboxHandler.getMaxRange((PlayerEntity)player);
            if (player.func_70092_e((double)this.toolboxPos.func_177958_n() + 0.5, (double)this.toolboxPos.func_177956_o(), (double)this.toolboxPos.func_177952_p() + 0.5) > maxRange * maxRange) {
                return;
            }
            if (!(blockEntity instanceof ToolboxTileEntity)) {
                return;
            }
            ToolboxHandler.unequip((PlayerEntity)player, this.hotbarSlot, false);
            if (this.slot < 0 || this.slot >= 8) {
                ToolboxHandler.syncData((PlayerEntity)player);
                return;
            }
            ToolboxTileEntity toolboxTileEntity = (ToolboxTileEntity)blockEntity;
            ItemStack playerStack = player.field_71071_by.func_70301_a(this.hotbarSlot);
            if (!playerStack.func_190926_b() && !ToolboxInventory.canItemsShareCompartment(playerStack, toolboxTileEntity.inventory.filters.get(this.slot))) {
                toolboxTileEntity.inventory.inLimitedMode(inventory -> {
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)playerStack, (boolean)false);
                    if (!remainder.func_190926_b()) {
                        remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)new ItemReturnInvWrapper((IInventory)player.field_71071_by), (ItemStack)remainder, (boolean)false);
                    }
                    if (remainder.func_190916_E() != playerStack.func_190916_E()) {
                        player.field_71071_by.func_70299_a(this.hotbarSlot, remainder);
                    }
                });
            }
            CompoundNBT compound = player.getPersistentData().func_74775_l("CreateToolboxData");
            String key = String.valueOf(this.hotbarSlot);
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a("Slot", this.slot);
            data.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.toolboxPos));
            compound.func_218657_a(key, (INBT)data);
            player.getPersistentData().func_218657_a("CreateToolboxData", (INBT)compound);
            toolboxTileEntity.connectPlayer(this.slot, (PlayerEntity)player, this.hotbarSlot);
            ToolboxHandler.syncData((PlayerEntity)player);
        });
        ctx.setPacketHandled(true);
    }
}

