/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlTextureUnit;
import com.jozufozu.flywheel.backend.state.RenderLayer;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.RenderedContraption;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.render.AllProgramSpecs;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.IWorld;
import org.lwjgl.opengl.GL11;

public class FlwContraptionManager
extends ContraptionRenderManager<RenderedContraption> {
    public FlwContraptionManager(IWorld world) {
        super(world);
    }

    @Override
    public void tick() {
        super.tick();
        for (RenderedContraption contraption : this.visible) {
            ContraptionLighter<?> lighter = contraption.getLighter();
            if (lighter.getBounds().volume() < (Integer)AllConfigs.CLIENT.maxContraptionLightVolume.get()) {
                lighter.tick(contraption);
            }
            contraption.kinetics.tick();
        }
    }

    @Override
    public void renderLayer(RenderLayerEvent event) {
        RenderLayer renderLayer;
        super.renderLayer(event);
        if (this.visible.isEmpty()) {
            return;
        }
        RenderType layer = event.getType();
        layer.func_228547_a_();
        GlTextureUnit.T4.makeActive();
        ContraptionProgram structureShader = (ContraptionProgram)CreateContexts.STRUCTURE.getProgram(AllProgramSpecs.STRUCTURE);
        structureShader.bind();
        structureShader.uploadViewProjection(event.viewProjection);
        structureShader.uploadCameraPos(event.camX, event.camY, event.camZ);
        for (RenderedContraption renderedContraption : this.visible) {
            renderedContraption.doRenderLayer(layer, structureShader);
        }
        if (Backend.getInstance().canUseInstancing() && (renderLayer = event.getLayer()) != null) {
            for (RenderedContraption renderer : this.visible) {
                renderer.materialManager.render(renderLayer, event.viewProjection, event.camX, event.camY, event.camZ);
            }
        }
        GlTextureUnit.T4.makeActive();
        GL11.glBindTexture((int)32879, (int)0);
        layer.func_228549_b_();
        GlTextureUnit.T0.makeActive();
    }

    @Override
    protected RenderedContraption create(Contraption c) {
        PlacementSimulationWorld renderWorld = ContraptionRenderDispatcher.setupRenderWorld(this.world, c);
        return new RenderedContraption(c, renderWorld);
    }

    @Override
    public void removeDeadRenderers() {
        boolean removed = this.renderInfos.values().removeIf(renderer -> {
            if (renderer.isDead()) {
                renderer.invalidate();
                return true;
            }
            return false;
        });
        if (removed) {
            this.collectVisible();
        }
    }
}

