/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.log;

import info.ata4.log.DialogFormatter;
import java.awt.Component;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JOptionPane;

public class DialogHandler
extends Handler {
    private final Component parentComponent;

    public DialogHandler(Component parentComponent) {
        this.parentComponent = parentComponent;
        this.setFormatter(new DialogFormatter());
        this.setLevel(Level.WARNING);
    }

    @Override
    public void publish(LogRecord record) {
        String title;
        int dialogType;
        String message;
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        if (record.getLevel() == Level.WARNING) {
            dialogType = 2;
            title = "Warning";
        } else if (record.getLevel() == Level.SEVERE) {
            dialogType = 0;
            title = "Error";
        } else {
            dialogType = 1;
            title = "Information";
        }
        JOptionPane.showMessageDialog(this.parentComponent, message, title, dialogType);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

