/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.file;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;

public class FilenameSanitizer {
    public static final Set<Character> ILLEGAL_CHARS;
    public static final Set<String> ILLEGAL_NAMES;

    public static String sanitize(String name) {
        StringBuilder sb = new StringBuilder(name);
        for (int i = 0; i < sb.length(); ++i) {
            if (!ILLEGAL_CHARS.contains(Character.valueOf(sb.charAt(i)))) continue;
            sb.deleteCharAt(i);
            --i;
        }
        name = sb.toString();
        if (ILLEGAL_NAMES.contains(name.toLowerCase())) {
            return "";
        }
        return name;
    }

    private FilenameSanitizer() {
    }

    static {
        HashSet<Character> illegalChars = new HashSet<Character>();
        HashSet<String> illegalNames = new HashSet<String>();
        for (int i = 0; i < 31; ++i) {
            illegalChars.add(Character.valueOf((char)i));
        }
        Character[] chars = new Character[]{Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf(':')};
        illegalChars.addAll(Arrays.asList(chars));
        illegalNames.add(".");
        illegalNames.add("..");
        if (SystemUtils.IS_OS_WINDOWS) {
            illegalChars.add(Character.valueOf('\"'));
            String[] names = new String[]{"con", "prn", "aux", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9"};
            illegalNames.addAll(Arrays.asList(names));
        }
        ILLEGAL_CHARS = Collections.unmodifiableSet(illegalChars);
        ILLEGAL_NAMES = Collections.unmodifiableSet(illegalNames);
    }
}

