/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer;

import info.ata4.io.Swappable;
import info.ata4.io.buffer.ByteBufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;

public class ByteBufferChannel
implements SeekableByteChannel,
Swappable {
    private final ByteBuffer buf;
    private boolean closed;

    public ByteBufferChannel(ByteBuffer bb) {
        this.buf = bb;
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder order) {
        this.buf.order(order);
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return ByteBufferUtils.transfer(this.buf, dst);
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (this.buf.isReadOnly()) {
            throw new NonWritableChannelException();
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return ByteBufferUtils.transfer(src, this.buf);
    }

    @Override
    public boolean isOpen() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public long position() throws IOException {
        return this.buf.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition > (long)this.buf.limit()) {
            throw new IllegalArgumentException();
        }
        this.buf.position((int)newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.buf.limit();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (size < (long)this.buf.limit()) {
            this.buf.limit((int)size);
        }
        return this;
    }
}

