/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.DataBridge;
import info.ata4.io.DataInput;
import info.ata4.io.StringInput;
import info.ata4.io.Struct;
import info.ata4.io.buffer.source.BufferedSource;
import info.ata4.io.buffer.source.BufferedSourceChannel;
import info.ata4.io.util.HalfFloat;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;

public class DataReader
extends DataBridge
implements DataInput,
StringInput {
    public DataReader(BufferedSource buf) {
        super(buf);
    }

    public void readStruct(Struct struct) throws IOException {
        struct.read(this);
    }

    public InputStream stream() {
        return Channels.newInputStream(new BufferedSourceChannel(this.buf));
    }

    @Override
    public void readBytes(byte[] b, int off, int len) throws IOException {
        this.buf.requestRead(len).get(b, off, len);
    }

    @Override
    public void readBuffer(ByteBuffer dst) throws IOException {
        while (dst.hasRemaining() && this.buf.read(dst) > 0) {
        }
        if (dst.hasRemaining()) {
            throw new EOFException();
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buf.requestRead(1).get() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buf.requestRead(1).get();
    }

    @Override
    public short readShort() throws IOException {
        return this.buf.requestRead(2).getShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.buf.requestRead(2).getChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.buf.requestRead(4).getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.buf.requestRead(8).getLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buf.requestRead(4).getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buf.requestRead(8).getDouble();
    }

    @Override
    public void readBytes(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public BigInteger readUnsignedLong() throws IOException {
        byte[] raw = new byte[8];
        this.readBytes(raw);
        if (this.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse(raw);
        }
        return new BigInteger(raw);
    }

    @Override
    public float readHalf() throws IOException {
        int hbits = this.readUnsignedShort();
        return HalfFloat.intBitsToFloat(hbits);
    }

    @Override
    public String readStringFixed(int length, Charset charset) throws IOException {
        byte[] raw = new byte[length];
        this.readBytes(raw);
        for (length = 0; length < raw.length && raw[length] != 0; ++length) {
        }
        if (length == 0) {
            return "";
        }
        return new String(raw, 0, length, charset);
    }

    @Override
    public String readStringFixed(int length) throws IOException {
        return this.readStringFixed(length, StandardCharsets.US_ASCII);
    }

    @Override
    public String readStringNull(int limit, Charset charset) throws IOException {
        byte b;
        ByteBuffer bb = ByteBuffer.allocate(limit);
        while ((b = this.readByte()) != 0) {
            if (!bb.hasRemaining()) continue;
            bb.put(b);
        }
        bb.flip();
        if (!bb.hasRemaining()) {
            return "";
        }
        return new String(bb.array(), 0, bb.limit(), charset);
    }

    @Override
    public String readStringNull(int limit) throws IOException {
        return this.readStringNull(limit, StandardCharsets.US_ASCII);
    }

    @Override
    public String readStringNull() throws IOException {
        return this.readStringNull(256);
    }

    @Override
    public <T extends Number> String readStringPrefixed(Class<T> prefixType, T limit, Charset charset) throws IOException {
        Number length;
        if (prefixType == Byte.TYPE) {
            length = this.readUnsignedByte();
        } else if (prefixType == Short.TYPE) {
            length = this.readUnsignedShort();
        } else if (prefixType == Integer.TYPE) {
            length = this.readUnsignedInt();
        } else {
            throw new IllegalArgumentException("Wrong prefix data type");
        }
        int len = length;
        if (len == 0) {
            return "";
        }
        byte[] raw = new byte[len];
        this.readBytes(raw);
        return new String(raw, 0, len, charset);
    }

    @Override
    public <T extends Number> String readStringPrefixed(Class<T> prefixType, T limit) throws IOException {
        return this.readStringPrefixed(prefixType, limit, StandardCharsets.US_ASCII);
    }
}

