/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.util;

import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DFace;
import info.ata4.bsplib.struct.DOccluderPolyData;
import info.ata4.bsplib.struct.DPlane;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.util.Winding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class WindingFactory {
    private static Map<DFace, Winding> faceCache = new HashMap<DFace, Winding>();
    private static Map<Map.Entry<DBrush, DBrushSide>, Winding> brushSideCache = new HashMap<Map.Entry<DBrush, DBrushSide>, Winding>();
    private static Map<DAreaportal, Winding> areaportalCache = new HashMap<DAreaportal, Winding>();
    private static Map<DOccluderPolyData, Winding> occluderCache = new HashMap<DOccluderPolyData, Winding>();
    private static Map<DPlane, Winding> planeCache = new HashMap<DPlane, Winding>();

    private WindingFactory() {
    }

    public static void clearCache() {
        faceCache.clear();
        brushSideCache.clear();
        areaportalCache.clear();
        occluderCache.clear();
        planeCache.clear();
    }

    public static Winding fromFace(BspData bsp, DFace face) {
        if (faceCache.containsKey(face)) {
            return faceCache.get(face);
        }
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        for (int i = 0; i < face.numedge; ++i) {
            int sedge = bsp.surfEdges.get(face.fstedge + i);
            int v = sedge < 0 ? bsp.edges.get((int)(-sedge)).v[1] : bsp.edges.get((int)sedge).v[0];
            verts.add(bsp.verts.get((int)v).point);
        }
        Winding w = new Winding(verts);
        faceCache.put(face, w);
        return w;
    }

    public static Winding fromSide(BspData bsp, DBrush brush, DBrushSide bside) {
        ImmutablePair<DBrush, DBrushSide> key = ImmutablePair.of(brush, bside);
        if (brushSideCache.containsKey(key)) {
            return brushSideCache.get(key);
        }
        int iplane = bside.pnum;
        boolean hasSide = false;
        Winding w = WindingFactory.fromPlane(bsp.planes.get(iplane));
        for (int i = 0; i < brush.numside; ++i) {
            int ibside2 = brush.fstside + i;
            DBrushSide bside2 = bsp.brushSides.get(ibside2);
            if (bside2 == bside) {
                hasSide = true;
                continue;
            }
            if (bside2.bevel) continue;
            int iplane2 = bside2.pnum;
            DPlane plane = bsp.planes.get(iplane2);
            DPlane flipPlane = new DPlane();
            flipPlane.normal = plane.normal.scalar(-1.0f);
            flipPlane.dist = -plane.dist;
            w = w.clipPlane(flipPlane, false);
        }
        if (!hasSide) {
            throw new IllegalArgumentException("Brush side is not part of brush!");
        }
        brushSideCache.put(key, w);
        return w;
    }

    public static Winding fromSide(BspData bsp, DBrush brush, int side) {
        int ibside = brush.fstside + side;
        DBrushSide bside = bsp.brushSides.get(ibside);
        return WindingFactory.fromSide(bsp, brush, bside);
    }

    public static Winding fromAreaportal(BspData bsp, DAreaportal ap) {
        if (areaportalCache.containsKey(ap)) {
            return areaportalCache.get(ap);
        }
        Winding w = bsp.clipPortalVerts.subList(ap.firstClipPortalVert, ap.firstClipPortalVert + ap.clipPortalVerts).stream().map(dVertex -> dVertex.point).collect(Collectors.collectingAndThen(Collectors.toList(), Winding::new));
        areaportalCache.put(ap, w);
        return w;
    }

    public static Winding fromOccluder(BspData bsp, DOccluderPolyData opd) {
        if (occluderCache.containsKey(opd)) {
            return occluderCache.get(opd);
        }
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        for (int k = 0; k < opd.vertexcount; ++k) {
            int pvi = bsp.occluderVerts.get(opd.firstvertexindex + k);
            verts.add(bsp.verts.get((int)pvi).point);
        }
        Winding w = new Winding(verts);
        occluderCache.put(opd, w);
        return w;
    }

    public static Winding fromPlane(DPlane pl) {
        if (planeCache.containsKey(pl)) {
            return planeCache.get(pl);
        }
        float dmax = -1.0f;
        int idir = -1;
        for (int i = 0; i < pl.normal.size; ++i) {
            float dc = Math.abs(pl.normal.get(i));
            if (dc <= dmax) continue;
            dmax = dc;
            idir = i;
        }
        if (idir == -1) {
            throw new RuntimeException("Plane " + pl + ": bad normal");
        }
        Vector3f vup = Vector3f.NULL;
        switch (idir) {
            case 0: 
            case 1: {
                vup = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case 2: {
                vup = new Vector3f(1.0f, 0.0f, 0.0f);
            }
        }
        float vdot = vup.dot(pl.normal);
        vup = vup.add(pl.normal.scalar(-vdot));
        vup = vup.normalize();
        Vector3f org = pl.normal.scalar(pl.dist);
        Vector3f vrt = vup.cross(pl.normal);
        vup = vup.scalar(56756.0f);
        vrt = vrt.scalar(56756.0f);
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        verts.add(org.sub(vrt).add(vup));
        verts.add(org.add(vrt).add(vup));
        verts.add(org.add(vrt).sub(vup));
        verts.add(org.sub(vrt).sub(vup));
        Winding w = new Winding(verts);
        planeCache.put(pl, w);
        return w;
    }
}

