/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.util;

import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DOccluderPolyData;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.util.AreaportalMapper;
import info.ata4.bspsrc.util.ConvexPolygon;
import info.ata4.bspsrc.util.Winding;
import info.ata4.bspsrc.util.WindingFactory;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class VectorUtil {
    public static double matchingAreaPercentage(DOccluderPolyData occluderPolyData, DBrush brush, DBrushSide brushSide, BspData bsp) {
        if (occluderPolyData.planenum == brushSide.pnum) {
            return VectorUtil.internalMatchingAreaPercentage(WindingFactory.fromOccluder(bsp, occluderPolyData), WindingFactory.fromSide(bsp, brush, brushSide));
        }
        return 0.0;
    }

    public static double matchingAreaPercentage(AreaportalMapper.AreaportalHelper apHelper, DBrush brush, DBrushSide brushSide, BspData bsp) {
        Set<Integer> planeNums = apHelper.getPlaneIndices();
        if (planeNums.contains(brushSide.pnum)) {
            return VectorUtil.internalMatchingAreaPercentage(apHelper.winding, WindingFactory.fromSide(bsp, brush, brushSide));
        }
        return 0.0;
    }

    private static double internalMatchingAreaPercentage(Winding w1, Winding w2) {
        ConvexPolygon w2Polygon;
        w1 = w1.removeDegenerated();
        w2 = w2.removeDegenerated();
        if (w1.size() < 3 || w2.size() < 3 || w1.isHuge() || w2.isHuge()) {
            return 0.0;
        }
        Vector3f origin = w1.get(0);
        Vector3f vec1 = w1.get(1).sub(origin);
        Vector3f vec2 = w1.get(2).sub(origin);
        Vector3f planeNormal = vec2.cross(vec1).normalize();
        Vector3f axis1 = w1.get(1).sub(origin).normalize();
        Vector3f axis2 = axis1.cross(planeNormal).normalize();
        ConvexPolygon w1Polygon = w1.stream().map(vertex -> vertex.getAsPointOnPlane(origin, axis1, axis2)).collect(Collectors.collectingAndThen(Collectors.toList(), ConvexPolygon::new));
        Optional<ConvexPolygon> intersectionPolygon = w1Polygon.getIntersectionPolygon(w2Polygon = w2.stream().map(vertex -> vertex.getAsPointOnPlane(origin, axis1, axis2)).collect(Collectors.collectingAndThen(Collectors.toList(), ConvexPolygon::new)));
        if (intersectionPolygon.isPresent()) {
            float intersectionArea = intersectionPolygon.get().getArea();
            if (intersectionArea < 1.0f) {
                intersectionArea = 0.0f;
            }
            return Math.min(intersectionArea / w1Polygon.getArea(), 1.0f);
        }
        return 0.0;
    }
}

