/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.util;

import info.ata4.bsplib.entity.KeyValue;
import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bspsrc.BspSourceConfig;
import info.ata4.bspsrc.VmfWriter;
import info.ata4.bspsrc.modules.VmfMeta;
import info.ata4.bspsrc.modules.geom.FaceSource;
import info.ata4.bspsrc.util.VectorUtil;
import info.ata4.bspsrc.util.Winding;
import info.ata4.bspsrc.util.WindingFactory;
import info.ata4.log.LogUtils;
import info.ata4.util.JavaUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AreaportalMapper {
    private static final Logger L = LogUtils.getLogger();
    private BspSourceConfig config;
    private BspData bsp;
    private ArrayList<AreaportalHelper> areaportalHelpers = new ArrayList();
    private ArrayList<DBrush> areaportalBrushes = new ArrayList();

    public AreaportalMapper(BspData bsp, BspSourceConfig config) {
        this.bsp = bsp;
        this.config = config;
        if (this.checkAreaportal()) {
            L.warning("Invalid areaportals, map was probably compiled with errors! Errors should be expected");
        }
        this.prepareApHelpers();
        this.prepareApBrushes();
    }

    private boolean checkAreaportal() {
        return this.bsp.areaportals.stream().filter(dAreaportal -> dAreaportal.portalKey != 0).anyMatch(dAreaportal -> dAreaportal.clipPortalVerts == 0);
    }

    private void prepareApHelpers() {
        for (DAreaportal dAreaportal : this.bsp.areaportals) {
            if (dAreaportal.portalKey == 0) continue;
            Optional<AreaportalHelper> matchingApHelper = this.areaportalHelpers.stream().filter(apHelper -> apHelper.winding.matches(WindingFactory.fromAreaportal(this.bsp, dAreaportal))).findAny();
            if (matchingApHelper.isPresent()) {
                matchingApHelper.get().addPortalId(dAreaportal.portalKey);
                continue;
            }
            AreaportalHelper apHelper2 = new AreaportalHelper(WindingFactory.fromAreaportal(this.bsp, dAreaportal));
            apHelper2.addPortalId(dAreaportal.portalKey);
            this.areaportalHelpers.add(apHelper2);
        }
    }

    private void prepareApBrushes() {
        this.areaportalBrushes.addAll(this.bsp.brushes.stream().filter(DBrush::isAreaportal).collect(Collectors.toList()));
    }

    public boolean hasValidGeometry(int portalId) {
        return this.areaportalHelpers.stream().filter(apHelper -> !apHelper.winding.isEmpty()).anyMatch(apHelper -> ((AreaportalHelper)apHelper).portalID.contains(portalId));
    }

    private Map<Integer, Integer> manualMapping() {
        Set<BrushProbabilitiesMapping> brushProbMappings = this.areaportalBrushes.stream().map(dBrush -> new BrushProbabilitiesMapping((DBrush)dBrush, this.areaportalBrushProb((DBrush)dBrush))).filter(mapping -> !((BrushProbabilitiesMapping)mapping).isEmpty()).collect(Collectors.toSet());
        HashMap<Integer, KeyValue> debugEntityInformation = new HashMap<Integer, KeyValue>();
        HashMap<Integer, Integer> finalBrushMapping = new HashMap<Integer, Integer>();
        while (!brushProbMappings.isEmpty()) {
            Optional<BrushMapping> opBrushMapping = brushProbMappings.stream().map(rec$ -> ((BrushProbabilitiesMapping)rec$).getOnlyMapping()).flatMap(JavaUtil::streamOpt).max(Comparator.comparingDouble(brushMapping -> brushMapping.probability));
            if (!opBrushMapping.isPresent()) {
                opBrushMapping = brushProbMappings.stream().flatMap(BrushProbabilitiesMapping::stream).max(Comparator.comparingDouble(mapping -> mapping.probability));
            }
            if (!opBrushMapping.isPresent()) {
                L.warning("Internal error occurred reallocating areaportals");
                assert (false);
                break;
            }
            BrushMapping brushMapping2 = opBrushMapping.get();
            OptionalInt opApId = brushMapping2.apHelper.getFirstNonOverlappingId(finalBrushMapping.keySet());
            if (!opApId.isPresent()) {
                L.warning("Internal error occurred reallocating areaportals");
                assert (false);
                break;
            }
            int areaportalId = opApId.getAsInt();
            int brushIndex = this.bsp.brushes.indexOf(brushMapping2.brush);
            finalBrushMapping.put(areaportalId, brushIndex);
            L.log(Level.FINEST, String.format("Mapped brush %d to areaportal %d[%s] with a probability of %.2g", brushIndex, areaportalId, brushMapping2.apHelper.portalID.stream().map(Object::toString).collect(Collectors.joining(", ")), brushMapping2.probability));
            debugEntityInformation.put(areaportalId, new KeyValue(brushMapping2.apHelper.portalID.stream().map(Object::toString).collect(Collectors.joining(", ", "areaportal_prob[", "]")), String.valueOf(brushMapping2.probability)));
            brushProbMappings.removeIf(mapping -> mapping.brush == brushMapping.brush);
            brushProbMappings.forEach(mapping -> mapping.probabilities.keySet().removeIf(areaportalHelper -> !areaportalHelper.getFirstNonOverlappingId(finalBrushMapping.keySet()).isPresent()));
            brushProbMappings.removeIf(rec$ -> ((BrushProbabilitiesMapping)rec$).isEmpty());
        }
        if (this.config.isDebug()) {
            this.bsp.entities.stream().filter(entity -> entity.getClassName().startsWith("func_areaportal")).forEach(entity -> {
                try {
                    int portalId = Integer.parseInt(entity.getValue("portalnumber"));
                    entity.setValue(debugEntityInformation.getOrDefault(portalId, new KeyValue("areaportal_prob[]", "0")));
                }
                catch (NumberFormatException e) {
                    L.log(Level.FINE, "func_areaportal portalnumber property is missing or invalid", e);
                }
            });
        }
        return finalBrushMapping;
    }

    private Map<AreaportalHelper, Double> areaportalBrushProb(DBrush dBrush) {
        return this.bsp.brushSides.subList(dBrush.fstside, dBrush.fstside + dBrush.numside).stream().flatMap(brushSide -> this.areaportalHelpers.stream().map(apHelper -> new AbstractMap.SimpleEntry<AreaportalHelper, Double>((AreaportalHelper)apHelper, VectorUtil.matchingAreaPercentage(apHelper, dBrush, brushSide, this.bsp))).filter(entry -> (Double)entry.getValue() > 0.0).limit(1L)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<Integer, Integer> orderedMapping() {
        int areaportalBrushCount = this.areaportalBrushes.size();
        List areaportalIds = this.areaportalHelpers.stream().flatMap(areaportalHelper -> ((AreaportalHelper)areaportalHelper).portalID.stream()).sorted().collect(Collectors.toList());
        return IntStream.range(0, Math.min(areaportalIds.size(), areaportalBrushCount)).boxed().collect(Collectors.toMap(areaportalIds::get, i -> this.bsp.brushes.indexOf(this.areaportalBrushes.get((int)i))));
    }

    public Map<Integer, Integer> getApBrushMapping() {
        if (!this.config.writeAreaportals) {
            return Collections.emptyMap();
        }
        if (this.areaportalHelpers.size() == 0) {
            L.info("No areaportals to reallocate...");
            return Collections.emptyMap();
        }
        if (this.config.apForceManualMapping) {
            L.info("Forced manual areaportal mapping method");
            return ApMappingMode.MANUAL.map(this);
        }
        if (this.areaportalHelpers.stream().mapToInt(value -> ((AreaportalHelper)value).portalID.size()).sum() == this.areaportalBrushes.size()) {
            L.info("Equal amount of areaporal entities and areaportal brushes. Using '" + (Object)((Object)ApMappingMode.ORDERED) + "' method");
            return ApMappingMode.ORDERED.map(this);
        }
        L.info("Unequal amount of areaporal entities and areaportal brushes. Falling back to '" + (Object)((Object)ApMappingMode.MANUAL) + "' method");
        return ApMappingMode.MANUAL.map(this);
    }

    public void writeDebugPortals(VmfWriter writer, VmfMeta vmfMeta, FaceSource faceSource) {
        for (AreaportalHelper areaportalHelper : this.areaportalHelpers) {
            writer.start("entity");
            writer.put("id", vmfMeta.getUID());
            writer.put("classname", "func_detail");
            writer.put("areaportalIDs", areaportalHelper.portalID.stream().map(Object::toString).collect(Collectors.joining(", ")));
            faceSource.writePolygon(areaportalHelper.winding, "tools/toolsskip", true);
            vmfMeta.writeMetaVisgroups(areaportalHelper.portalID.stream().map(id -> vmfMeta.visgroups().getVisgroup("AreaportalID").getVisgroup(String.valueOf(id))).collect(Collectors.toList()));
            writer.end("entity");
        }
    }

    public class AreaportalHelper {
        private final TreeSet<Integer> portalID = new TreeSet();
        public final Winding winding;
        private final HashSet<Integer> planeIndices = new HashSet();

        public AreaportalHelper(Winding winding) {
            Objects.requireNonNull(winding);
            this.winding = winding;
        }

        public void addPortalId(int portalId) {
            Set planeNums = ((AreaportalMapper)AreaportalMapper.this).bsp.areaportals.stream().filter(dAreaportal -> dAreaportal.portalKey == portalId).map(dAreaportal -> dAreaportal.planenum).collect(Collectors.toSet());
            if (planeNums.isEmpty()) {
                throw new IllegalArgumentException("Specified portalkey doesn't exist");
            }
            this.portalID.add(portalId);
            this.planeIndices.addAll(planeNums);
        }

        public Set<Integer> getPlaneIndices() {
            assert (this.planeIndices.size() <= 2);
            return Collections.unmodifiableSet(this.planeIndices);
        }

        public OptionalInt getFirstNonOverlappingId(Collection<Integer> collection) {
            return this.portalID.stream().filter(id -> !collection.contains(id)).mapToInt(i -> i).findFirst();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AreaportalHelper that = (AreaportalHelper)o;
            if (!this.portalID.equals(that.portalID)) {
                return false;
            }
            return Objects.equals(this.winding, that.winding);
        }

        public int hashCode() {
            int result = this.portalID.hashCode();
            result = 31 * result + (this.winding != null ? this.winding.hashCode() : 0);
            return result;
        }
    }

    private static final class BrushMapping {
        public final DBrush brush;
        public final AreaportalHelper apHelper;
        public final double probability;

        public BrushMapping(DBrush brush, AreaportalHelper apHelper, double probability) {
            this.brush = Objects.requireNonNull(brush);
            this.apHelper = Objects.requireNonNull(apHelper);
            this.probability = probability;
        }
    }

    public static enum ApMappingMode {
        MANUAL(rec$ -> AreaportalMapper.access$200((AreaportalMapper)rec$)),
        ORDERED(rec$ -> AreaportalMapper.access$100((AreaportalMapper)rec$));

        private Function<AreaportalMapper, Map<Integer, Integer>> mapper;

        private ApMappingMode(Function<AreaportalMapper, Map<Integer, Integer>> mapper) {
            this.mapper = mapper;
        }

        public Map<Integer, Integer> map(AreaportalMapper apMapper) {
            return this.mapper.apply(apMapper);
        }

        public String toString() {
            return super.toString().substring(0, 1).toUpperCase() + super.toString().substring(1).toLowerCase();
        }
    }

    private static final class BrushProbabilitiesMapping {
        public final DBrush brush;
        public final Map<AreaportalHelper, Double> probabilities;

        private BrushProbabilitiesMapping(DBrush brush, Map<AreaportalHelper, Double> probabilities) {
            this.brush = Objects.requireNonNull(brush);
            this.probabilities = Objects.requireNonNull(probabilities);
        }

        private boolean isEmpty() {
            return this.probabilities.isEmpty();
        }

        private Optional<BrushMapping> getOnlyMapping() {
            if (this.probabilities.size() > 1) {
                return Optional.empty();
            }
            return this.probabilities.entrySet().stream().findAny().map(this::brushMappingFromEntry);
        }

        public Stream<BrushMapping> stream() {
            return this.probabilities.entrySet().stream().map(this::brushMappingFromEntry);
        }

        private BrushMapping brushMappingFromEntry(Map.Entry<AreaportalHelper, Double> entry) {
            return new BrushMapping(this.brush, entry.getKey(), entry.getValue());
        }
    }
}

