/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.texture.tooltextures.definitions;

import info.ata4.bsplib.struct.BrushFlag;
import info.ata4.bsplib.struct.SurfaceFlag;
import info.ata4.bspsrc.modules.texture.tooltextures.ToolTextureDefinition;
import info.ata4.bspsrc.modules.texture.tooltextures.definitions.SourceToolTextureDefinition;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum CsgoToolTextureDefinitions implements ToolTextureDefinition
{
    GRENADE_CLIP("tools/toolsgrenadeclip", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_CURRENT_90, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    DRONE_CLIP("tools/toolsdroneclip", new ToolTextureDefinition.Builder().setRequiredFlags(BrushFlag.CONTENTS_CURRENT_180, BrushFlag.CONTENTS_DETAIL).setRequiredFlags(SurfaceFlag.SURF_NODRAW, SurfaceFlag.SURF_NOLIGHT).build()),
    CLIP_CONCRETE("tools/toolsclip_concrete", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("concrete").build()),
    CLIP_DIRT("tools/toolsclip_dirt", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("dirt").build()),
    CLIP_GLASS("tools/toolsclip_glass", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("glassfloor").build()),
    CLIP_GRASS("tools/toolsclip_grass", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("grass").build()),
    CLIP_GRAVEL("tools/toolsclip_gravel", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("gravel").build()),
    CLIP_METAL("tools/toolsclip_metal", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("metal").build()),
    CLIP_METAL_SAND_BARREL("tools/toolsclip_metal_sand_barrel", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("metal_sand_barrel").build()),
    CLIP_METALGRATE("tools/toolsclip_metalgrate", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("metalgrate").build()),
    CLIP_METALVEHICLE("tools/toolsclip_metalvehicle", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("metalvehicle").build()),
    CLIP_PLASTIC("tools/toolsclip_plastic", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("plastic").build()),
    CLIP_RUBBER("tools/toolsclip_rubber", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("rubber").build()),
    CLIP_RUBBERTIRE("tools/toolsclip_rubbertire", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("rubbertire").build()),
    CLIP_SAND("tools/toolsclip_sand", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("sand").build()),
    CLIP_SNOW("tools/toolsclip_snow", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("snow").build()),
    CLIP_TILE("tools/toolsclip_tile", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("tile").build()),
    CLIP_WOOD("tools/toolsclip_wood", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("wood").build()),
    CLIP_WOOD_BASKET("tools/toolsclip_wood_basket", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("Wood_Basket").build()),
    CLIP_WOOD_CRATE("tools/toolsclip_wood_crate", new ToolTextureDefinition.Builder(SourceToolTextureDefinition.CLIP).setSurfaceProperty("Wood_Crate").build());

    private final String materialName;
    private final ToolTextureDefinition toolTextureDefinition;

    private CsgoToolTextureDefinitions(String materialName, ToolTextureDefinition toolTextureDefinition) {
        this.materialName = Objects.requireNonNull(materialName);
        this.toolTextureDefinition = Objects.requireNonNull(toolTextureDefinition);
    }

    public String getMaterialName() {
        return this.materialName;
    }

    @Override
    public Optional<String> getSurfaceProperty() {
        return this.toolTextureDefinition.getSurfaceProperty();
    }

    @Override
    public Map<BrushFlag, Boolean> getBrushFlagsRequirements() {
        return this.toolTextureDefinition.getBrushFlagsRequirements();
    }

    @Override
    public Map<SurfaceFlag, Boolean> getSurfaceFlagsRequirements() {
        return this.toolTextureDefinition.getSurfaceFlagsRequirements();
    }

    public static Map<String, ToolTextureDefinition> getAll() {
        return Arrays.stream(CsgoToolTextureDefinitions.values()).collect(Collectors.toMap(CsgoToolTextureDefinitions::getMaterialName, definition -> definition));
    }
}

