/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.texture.tooltextures;

import info.ata4.bsplib.struct.BrushFlag;
import info.ata4.bsplib.struct.SurfaceFlag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface ToolTextureDefinition {
    public Optional<String> getSurfaceProperty();

    public Map<BrushFlag, Boolean> getBrushFlagsRequirements();

    public Map<SurfaceFlag, Boolean> getSurfaceFlagsRequirements();

    public static class Builder {
        private String surfaceProperty;
        private final Map<BrushFlag, Boolean> brushFlagsRequirements = new HashMap<BrushFlag, Boolean>();
        private final Map<SurfaceFlag, Boolean> surfaceFlagsRequirements = new HashMap<SurfaceFlag, Boolean>();

        public Builder() {
            this((String)null);
        }

        public Builder(String surfaceProperty) {
            this.surfaceProperty = surfaceProperty;
        }

        public Builder(ToolTextureDefinition definition) {
            this((String)definition.getSurfaceProperty().orElse(null));
            this.brushFlagsRequirements.putAll(definition.getBrushFlagsRequirements());
            this.surfaceFlagsRequirements.putAll(definition.getSurfaceFlagsRequirements());
        }

        public Builder setSurfaceProperty(String surfaceProperty) {
            this.surfaceProperty = Objects.requireNonNull(surfaceProperty);
            return this;
        }

        public Builder setRequiredFlags(BrushFlag ... brushFlags) {
            return this.setFlags(this.brushFlagsRequirements, true, brushFlags);
        }

        public Builder setForbiddenFlags(BrushFlag ... brushFlags) {
            return this.setFlags(this.brushFlagsRequirements, false, brushFlags);
        }

        public Builder setRequiredFlags(SurfaceFlag ... surfaceFlags) {
            return this.setFlags(this.surfaceFlagsRequirements, true, surfaceFlags);
        }

        public Builder setForbiddenFlags(SurfaceFlag ... surfaceFlags) {
            return this.setFlags(this.surfaceFlagsRequirements, false, surfaceFlags);
        }

        public Builder setIrrelevantFlags(BrushFlag ... brushFlags) {
            Arrays.asList(brushFlags).forEach(this.brushFlagsRequirements.keySet()::remove);
            return this;
        }

        public Builder setIrrelevantFlags(SurfaceFlag ... surfaceFlags) {
            Arrays.asList(surfaceFlags).forEach(this.surfaceFlagsRequirements.keySet()::remove);
            return this;
        }

        @SafeVarargs
        private final <K> Builder setFlags(Map<K, Boolean> set, boolean state, K ... ks) {
            for (K k : ks) {
                set.put(k, state);
            }
            return this;
        }

        public Builder clearBrushFlagRequirements() {
            this.brushFlagsRequirements.clear();
            return this;
        }

        public Builder clearSurfaceFlagRequirements() {
            this.surfaceFlagsRequirements.clear();
            return this;
        }

        public ToolTextureDefinition build() {
            return new ToolTextureDefinition(){
                private final String surfaceProperty;
                private final Map<SurfaceFlag, Boolean> surfaceFlagsRequirements;
                private final Map<BrushFlag, Boolean> brushFlagsRequirements;
                {
                    this.surfaceProperty = surfaceProperty;
                    this.surfaceFlagsRequirements = Collections.unmodifiableMap(new HashMap(surfaceFlagsRequirements));
                    this.brushFlagsRequirements = Collections.unmodifiableMap(new HashMap(brushFlagsRequirements));
                }

                @Override
                public Optional<String> getSurfaceProperty() {
                    return Optional.ofNullable(this.surfaceProperty);
                }

                @Override
                public Map<BrushFlag, Boolean> getBrushFlagsRequirements() {
                    return this.brushFlagsRequirements;
                }

                @Override
                public Map<SurfaceFlag, Boolean> getSurfaceFlagsRequirements() {
                    return this.surfaceFlagsRequirements;
                }
            };
        }
    }
}

