/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules.texture;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bspsrc.modules.ModuleRead;
import info.ata4.bspsrc.modules.texture.TextureBuilder;
import info.ata4.bspsrc.modules.texture.ToolTextureMatcher;
import info.ata4.bspsrc.modules.texture.tooltextures.ToolTextureSet;
import info.ata4.log.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class TextureSource
extends ModuleRead {
    private static final Logger L = LogUtils.getLogger();
    private static final String CONTENT_GROUP = "content";
    private static final String CUBEMAP_X_GROUP = "x";
    private static final String CUBEMAP_Y_GROUP = "y";
    private static final String CUBEMAP_Z_GROUP = "z";
    private final Pattern originPattern;
    private final Pattern wvtPatchPattern;
    private final Pattern waterPatchPattern;
    private Map<Integer, Set<Integer>> cubemapToSideList = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Integer> texnameToCubemap = new HashMap<Integer, Integer>();
    private List<String> texnamesFixed = new ArrayList<String>();
    private boolean fixTextureNames;
    private boolean fixToolTextures;
    private ToolTextureMatcher toolTextureMatcher = new ToolTextureMatcher(ToolTextureSet.forGame(this.bspFile.getSourceApp().getAppID()));

    public TextureSource(BspFileReader reader) {
        super(reader);
        String bspFileName = reader.getBspFile().getName();
        this.originPattern = TextureSource.compileOriginPattern(bspFileName);
        this.wvtPatchPattern = TextureSource.compileWvtPatchPattern(bspFileName);
        this.waterPatchPattern = TextureSource.compileWaterPatchPattern(bspFileName);
        reader.loadTexInfo();
        reader.loadTexData();
        reader.loadCubemaps();
        this.processTextureNames();
    }

    private void processTextureNames() {
        for (int i = 0; i < this.bsp.texnames.size(); ++i) {
            String textureOld = this.bsp.texnames.get(i);
            String textureNew = TextureSource.canonizeTextureName(textureOld);
            Matcher matcher = this.wvtPatchPattern.matcher(textureNew);
            if (matcher.find()) {
                textureNew = this.removeMatchedPrefixSuffix(matcher);
            }
            if ((matcher = this.waterPatchPattern.matcher(textureNew)).find()) {
                textureNew = this.removeMatchedPrefixSuffix(matcher);
            }
            if ((matcher = this.originPattern.matcher(textureNew)).find()) {
                try {
                    int cx = Integer.valueOf(matcher.group(CUBEMAP_X_GROUP));
                    int cy = Integer.valueOf(matcher.group(CUBEMAP_Y_GROUP));
                    int cz = Integer.valueOf(matcher.group(CUBEMAP_Z_GROUP));
                    this.setCubemapForTexname(i, cx, cy, cz);
                }
                catch (NumberFormatException e) {
                    L.log(Level.WARNING, "Error parsing cubemap position from regex. Matcher: " + matcher.pattern().pattern() + ", input: " + textureNew, e);
                }
                textureNew = this.removeMatchedPrefixSuffix(matcher);
            }
            if (!textureNew.equalsIgnoreCase(textureOld)) {
                L.log(Level.FINEST, "{0} -> {1}", new Object[]{textureOld, textureNew});
            }
            this.texnamesFixed.add(textureNew);
        }
    }

    private String removeMatchedPrefixSuffix(Matcher matcher) {
        return matcher.replaceFirst("${content}");
    }

    private void setCubemapForTexname(int itexname, int cx, int cy, int cz) {
        for (int i = 0; i < this.bsp.cubemaps.size(); ++i) {
            int[] origin = this.bsp.cubemaps.get((int)i).origin;
            if (cx != origin[0] && cy != origin[1] && cz != origin[2]) continue;
            if (L.isLoggable(Level.FINEST)) {
                L.log(Level.FINEST, "TN: {0} C: {1}", new Object[]{itexname, i});
            }
            this.texnameToCubemap.put(itexname, i);
            return;
        }
        L.log(Level.FINER, "Couldn''t find cubemap for coordinates ({0}, {1}, {2})", new Object[]{cx, cy, cz});
    }

    public TextureBuilder getTextureBuilder() {
        return new TextureBuilder(this, this.bsp, this.toolTextureMatcher);
    }

    public void addBrushSideID(int itexname, int side) {
        Integer icubemap = this.texnameToCubemap.get(itexname);
        if (icubemap == null) {
            return;
        }
        Set<Integer> sides = this.cubemapToSideList.get(icubemap);
        if (sides == null) {
            sides = new HashSet<Integer>();
            this.cubemapToSideList.put(icubemap, sides);
        }
        sides.add(side);
    }

    public Set<Integer> getBrushSidesForCubemap(int icubemap) {
        return this.cubemapToSideList.get(icubemap);
    }

    public String getTextureName(short itexinfo) {
        try {
            int ti = this.bsp.texinfos.get((int)itexinfo).texdata;
            int td = this.bsp.texdatas.get((int)ti).texname;
            if (this.fixTextureNames) {
                return this.texnamesFixed.get(td);
            }
            return this.bsp.texnames.get(td);
        }
        catch (IndexOutOfBoundsException ex) {
            return "tools/toolsskip";
        }
    }

    public static String canonizeTextureName(String textureNew) {
        textureNew = textureNew.toLowerCase(Locale.ROOT);
        textureNew = FilenameUtils.separatorsToUnix(textureNew);
        return textureNew;
    }

    public List<String> getFixedTextureNames() {
        return Collections.unmodifiableList(this.texnamesFixed);
    }

    public boolean isFixTextureNames() {
        return this.fixTextureNames;
    }

    public void setFixTextureNames(boolean fixTextureNames) {
        this.fixTextureNames = fixTextureNames;
    }

    public boolean isFixToolTextures() {
        return this.fixToolTextures;
    }

    public void setFixToolTextures(boolean fixToolTextures) {
        this.fixToolTextures = fixToolTextures;
    }

    private static Pattern compileOriginPattern(String bspFileName) {
        return Pattern.compile(String.format("maps/%s/(?<%s>.+)_(?<%s>-?\\d+)_(?<%s>-?\\d+)_(?<%s>-?\\d+)", bspFileName, CONTENT_GROUP, CUBEMAP_X_GROUP, CUBEMAP_Y_GROUP, CUBEMAP_Z_GROUP));
    }

    private static Pattern compileWvtPatchPattern(String bspFileName) {
        return Pattern.compile(String.format("maps/%s/(?<%s>.+)_wvt_patch", bspFileName, CONTENT_GROUP));
    }

    private static Pattern compileWaterPatchPattern(String bspFileName) {
        return Pattern.compile(String.format("maps/%s/(?<%s>.+)_depth_-?\\d+", bspFileName, CONTENT_GROUP));
    }

    public static Predicate<String> isPatchedMaterial(String bspFileName) {
        Pattern originPattern = TextureSource.compileOriginPattern(bspFileName);
        Pattern wvtPatchPattern = TextureSource.compileWvtPatchPattern(bspFileName);
        Pattern waterPatchPattern = TextureSource.compileWaterPatchPattern(bspFileName);
        return fileName -> {
            String canonizedName = TextureSource.canonizeTextureName(fileName);
            return originPattern.matcher(canonizedName).find() || wvtPatchPattern.matcher(canonizedName).find() || waterPatchPattern.matcher(canonizedName).find();
        };
    }
}

