/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DPlane;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.bspsrc.modules.ModuleRead;
import info.ata4.bspsrc.modules.geom.BrushUtils;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class BspProtection
extends ModuleRead {
    public static final String BSPPROTECT_FILE = "entities.dat";
    public static final String VMEX_LOCKED_TEX = "tools/locked";
    public static final String VMEX_LOCKED_ENT = "no_decomp";
    private static final float EPS_SIZE = 0.01f;
    private static final float ALIGNED_ALPHA = 0.99f;
    private static final float NODRAW_RATIO_LIMIT = 0.9f;
    private static final Vector3f PB1 = new Vector3f(1.0f, 4.0f, 9.0f);
    private static final Vector3f PB2 = new Vector3f(4.0f, 9.0f, 1.0f);
    private static final Vector3f PB3 = new Vector3f(9.0f, 1.0f, 4.0f);
    private static final Logger L = LogUtils.getLogger();
    private final TextureSource texsrc;
    private boolean flaggedEnt;
    private boolean flaggedTex;
    private boolean flaggedBrush;
    private boolean encryptedEnt;
    private boolean obfuscatedEnt;
    private boolean modifedTexinfo;
    private List<DBrush> protBrushes = new ArrayList<DBrush>();
    private List<Entity> protEntities = new ArrayList<Entity>();

    public BspProtection(BspFileReader reader, TextureSource texsrc) {
        super(reader);
        reader.loadEntities();
        reader.loadPlanes();
        reader.loadBrushes();
        reader.loadBrushSides();
        this.texsrc = texsrc;
    }

    public boolean check() {
        this.flaggedEnt = false;
        this.flaggedTex = false;
        this.flaggedBrush = false;
        this.encryptedEnt = false;
        this.obfuscatedEnt = false;
        this.modifedTexinfo = false;
        this.checkBrushes();
        this.checkBrushSides();
        this.checkEntities();
        this.checkTextures();
        this.checkPakfile();
        boolean prot = this.isProtected();
        if (!prot) {
            L.fine("Nothing found");
        }
        return prot;
    }

    public boolean isProtected() {
        return this.flaggedEnt || this.flaggedTex || this.flaggedBrush || this.encryptedEnt || this.obfuscatedEnt || this.modifedTexinfo;
    }

    public boolean hasEntityFlag() {
        return this.flaggedEnt;
    }

    public boolean hasTextureFlag() {
        return this.flaggedTex;
    }

    public boolean hasBrushFlag() {
        return this.flaggedBrush;
    }

    public boolean hasEncryptedEntities() {
        return this.encryptedEnt;
    }

    public boolean hasObfuscatedEntities() {
        return this.obfuscatedEnt;
    }

    public boolean hasModifiedTexinfo() {
        return this.modifedTexinfo;
    }

    public List<String> getProtectionMethods() {
        ArrayList<String> methods = new ArrayList<String>();
        if (this.hasEntityFlag()) {
            methods.add("VMEX entity flag (no_decomp)");
        }
        if (this.hasTextureFlag()) {
            methods.add("VMEX texture flag (tools/locked)");
        }
        if (this.hasBrushFlag()) {
            methods.add("VMEX protector brush flag");
        }
        if (this.hasEncryptedEntities()) {
            methods.add("BSPProtect entity encryption");
        }
        if (this.hasObfuscatedEntities()) {
            methods.add("IID entity obfuscation");
        }
        if (this.hasModifiedTexinfo()) {
            methods.add("IID nodraw texture hack");
        }
        return methods;
    }

    public List<DBrush> getProtectedBrushes() {
        ArrayList<DBrush> list = new ArrayList<DBrush>();
        list.addAll(this.protBrushes);
        return list;
    }

    public boolean isProtectedBrush(DBrush brush) {
        return this.protBrushes.contains(brush);
    }

    public List<Entity> getProtectedEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        list.addAll(this.protEntities);
        return list;
    }

    public boolean isProtectedEntity(Entity entity) {
        return this.protEntities.contains(entity);
    }

    private void checkBrushes() {
        L.fine("Checking for protector prefab");
        DBrush b1 = null;
        DBrush b2 = null;
        DBrush b3 = null;
        for (DBrush b : this.bsp.brushes) {
            if (!this.isAlignedBrush(b) || !this.isSameTexBrush(b)) continue;
            Vector3f bsize = BrushUtils.getBounds(this.bsp, b).getSize();
            if (PB1.sub(bsize).length() < 0.01f) {
                b1 = b;
            }
            if (PB2.sub(bsize).length() < 0.01f) {
                b2 = b;
            }
            if (PB3.sub(bsize).length() < 0.01f) {
                b3 = b;
            }
            if (b1 == null || b2 == null || b3 == null) continue;
            L.fine("Found protector prefab!");
            this.flaggedBrush = true;
            this.protBrushes.add(b1);
            this.protBrushes.add(b2);
            this.protBrushes.add(b3);
            b1 = null;
            b2 = null;
            b3 = null;
        }
    }

    private void checkBrushSides() {
        L.log(Level.FINE, "Checking for nodraw brush sides (ratio limit: {0})", Float.valueOf(0.9f));
        double nodrawSides = 0.0;
        for (DBrushSide bs : this.bsp.brushSides) {
            if (bs.texinfo != 0) continue;
            nodrawSides += 1.0;
        }
        double nodrawRatio = nodrawSides / (double)this.bsp.brushSides.size();
        boolean bl = this.modifedTexinfo = nodrawRatio > (double)0.9f;
        if (this.modifedTexinfo) {
            L.fine("Found nodraw hack!");
        }
    }

    private void checkEntities() {
        L.fine("Checking for entity lock key \"no_decomp\" and obfuscated targetnames");
        int targetnames = 0;
        int targetnamesObfs = 0;
        for (Entity ent : this.bsp.entities) {
            String targetName = ent.getTargetName();
            if (targetName != null) {
                ++targetnames;
                if (targetName.matches("^[0-9]+$")) {
                    ++targetnamesObfs;
                }
            }
            for (String key : ent.getKeys()) {
                if (!key.equals(VMEX_LOCKED_ENT)) continue;
                L.fine("Found lock key!");
                this.protEntities.add(ent);
                this.flaggedEnt = true;
            }
        }
        boolean bl = this.obfuscatedEnt = targetnames > 0 && targetnames == targetnamesObfs;
        if (this.obfuscatedEnt) {
            L.fine("Found obfuscation!");
        }
    }

    private void checkTextures() {
        L.fine("Checking for lock texture \"tools/locked\"");
        for (String texname : this.bsp.texnames) {
            if (!texname.equalsIgnoreCase(VMEX_LOCKED_TEX)) continue;
            L.fine("Found lock texture!");
            this.flaggedTex = true;
            return;
        }
    }

    private void checkPakfile() {
        L.fine("Checking for encrypted entities inside pakfile (file: \"entities.dat\")");
        if (this.bspFile.getVersion() != 20) {
            this.encryptedEnt = false;
            return;
        }
        try (ZipFile zip = this.bspFile.getPakFile().getZipFile();){
            if (zip.getEntries(BSPPROTECT_FILE).iterator().hasNext()) {
                L.fine("Found encrypted entities!");
                this.encryptedEnt = true;
            }
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Couldn't read pakfile", ex);
            this.encryptedEnt = false;
        }
    }

    private boolean isAlignedBrush(DBrush brush) {
        if (brush.numside != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            DBrushSide bs = this.bsp.brushSides.get(brush.fstside + i);
            DPlane bpl = this.bsp.planes.get(bs.pnum);
            for (float value : bpl.normal) {
                if (!(Math.abs(value) > 0.99f)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSameTexBrush(DBrush brush) {
        DBrushSide bs = this.bsp.brushSides.get(brush.fstside);
        String texname = this.texsrc.getTextureName(bs.texinfo);
        if (texname.equals("tools/toolsskip")) {
            return false;
        }
        for (int i = 1; i < brush.numside; ++i) {
            bs = this.bsp.brushSides.get(brush.fstside + i);
            String nexttexname = this.texsrc.getTextureName(bs.texinfo);
            if (texname.equalsIgnoreCase(nexttexname)) continue;
            return false;
        }
        return true;
    }
}

