/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.modules;

import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bspsrc.modules.ModuleRead;
import info.ata4.bspsrc.modules.texture.TextureSource;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BspDependencies
extends ModuleRead {
    public BspDependencies(BspFileReader reader) {
        super(reader);
        reader.loadEntities();
    }

    public Set<String> getMaterials() {
        TreeSet<String> materials = new TreeSet<String>();
        TextureSource texsrc = new TextureSource(this.reader);
        for (String texname : texsrc.getFixedTextureNames()) {
            materials.add("materials/" + texname + ".vmt");
        }
        for (Entity ent : this.bsp.entities) {
            try {
                for (String value : ent.getValues()) {
                    if (!value.startsWith("materials/") && !value.endsWith(".vtf") && !value.endsWith(".vmt")) continue;
                    String texture = TextureSource.canonizeTextureName(value);
                    if (!texture.startsWith("materials/")) {
                        texture = "materials/" + texture;
                    }
                    if (!texture.endsWith(".vtf") && !texture.endsWith(".vmt")) {
                        texture = texture + ".vmt";
                    }
                    materials.add(texture);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return materials;
    }

    public Set<String> getModels() {
        this.reader.loadStaticProps();
        TreeSet<String> models = new TreeSet<String>();
        for (Entity ent : this.bsp.entities) {
            try {
                for (String value : ent.getValues()) {
                    if (!value.endsWith(".mdl")) continue;
                    models.add(value);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        models.addAll(this.bsp.staticPropName);
        return models;
    }

    public Set<String> getSoundFiles() {
        TreeSet<String> soundFiles = new TreeSet<String>();
        for (Entity ent : this.bsp.entities) {
            for (Map.Entry<String, String> kv : ent.getEntrySet()) {
                String value = kv.getValue();
                if (!value.startsWith("sound/") && !value.endsWith(".wav") && !value.endsWith(".mp3")) continue;
                if (!value.startsWith("sound/")) {
                    value = "sound/" + value;
                }
                soundFiles.add(value);
            }
        }
        return soundFiles;
    }

    public Set<String> getSoundScripts() {
        TreeSet<String> soundScripts = new TreeSet<String>();
        for (Entity ent : this.bsp.entities) {
            for (Map.Entry<String, String> kv : ent.getEntrySet()) {
                if (ent.getClassName().equals("env_soundscape")) continue;
                String key = kv.getKey();
                String value = kv.getValue();
                if (!key.contains("sound") && !key.contains("noise") || value == null || value.length() == 0 || value.startsWith("!") || value.matches("^-?[0-9]+$")) continue;
                soundScripts.add(value);
            }
        }
        return soundScripts;
    }

    public Set<String> getSoundscapes() {
        TreeSet<String> soundScapes = new TreeSet<String>();
        for (Entity ent : this.bsp.entities) {
            if (!ent.getClassName().equals("env_soundscape")) continue;
            soundScapes.add(ent.getValue("soundscape"));
        }
        return soundScapes;
    }

    public Set<String> getParticles() {
        TreeSet<String> particles = new TreeSet<String>();
        for (Entity ent : this.bsp.entities) {
            try {
                if (!ent.getClassName().equals("info_particle_system")) continue;
                particles.add(ent.getValue("effect_name"));
            }
            catch (NullPointerException nullPointerException) {}
        }
        return particles;
    }
}

