/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc;

import java.io.File;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public class BspFileEntry {
    private final File bspFile;
    private File vmfFile;
    private File pakfileDir;
    private File nmoFile;
    private File nmosFile;

    public BspFileEntry(File bspFile) {
        this(bspFile, null);
    }

    public BspFileEntry(File bspFile, File vmfFile) {
        Objects.requireNonNull(bspFile);
        if (vmfFile == null) {
            vmfFile = BspFileEntry.replaceExtension(bspFile, "_d.vmf");
        }
        this.bspFile = bspFile;
        this.vmfFile = vmfFile;
        this.pakfileDir = BspFileEntry.replaceExtension(vmfFile, "");
        this.nmoFile = BspFileEntry.replaceExtension(bspFile, ".nmo");
        this.nmosFile = BspFileEntry.replaceExtension(vmfFile, ".nmos");
    }

    private static File replaceExtension(File file, String newExt) {
        String base = FilenameUtils.removeExtension(file.getName());
        File parentFile = file.getAbsoluteFile().getParentFile();
        return new File(parentFile, base + newExt);
    }

    public File getBspFile() {
        return this.bspFile;
    }

    public File getVmfFile() {
        return this.vmfFile;
    }

    public void setVmfFile(File vmfFile) {
        this.vmfFile = vmfFile;
    }

    public File getPakDir() {
        return this.pakfileDir;
    }

    public void setPakDir(File pakfileDir) {
        this.pakfileDir = pakfileDir;
    }

    public File getNmoFile() {
        return this.nmoFile;
    }

    public File getNmosFile() {
        return this.nmosFile;
    }

    public void setNmosFile(File nmosFile) {
        Objects.requireNonNull(nmosFile);
        this.nmosFile = nmosFile;
    }

    public String toString() {
        return this.bspFile.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BspFileEntry other = (BspFileEntry)obj;
        return this.bspFile == other.bspFile || this.bspFile.equals(other.bspFile);
    }

    public int hashCode() {
        return this.bspFile.hashCode();
    }
}

