/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.lump;

import info.ata4.bsplib.io.LzmaUtil;
import info.ata4.io.buffer.ByteBufferInputStream;
import info.ata4.io.buffer.ByteBufferOutputStream;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLump {
    private static final Logger L = LogUtils.getLogger();
    private ByteBuffer buffer = ByteBuffer.allocate(0);
    private int offset;
    private int version = 0;
    private int fourCC = 0;
    private boolean compressed = false;

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.buffer.limit();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buf) {
        this.buffer = buf;
        this.buffer.rewind();
        this.setCompressed(LzmaUtil.isCompressed(this.buffer));
    }

    public InputStream getInputStream() {
        ByteBuffer buf = this.getBuffer();
        buf.rewind();
        return new ByteBufferInputStream(buf);
    }

    public OutputStream getOutputStream() {
        ByteBuffer buf = this.getBuffer();
        buf.rewind();
        return new ByteBufferOutputStream(buf);
    }

    public void setVersion(int vers) {
        this.version = vers;
    }

    public int getVersion() {
        return this.version;
    }

    public int getFourCC() {
        return this.fourCC;
    }

    public void setFourCC(int fourCC) {
        this.fourCC = fourCC;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void compress() {
        if (this.compressed) {
            return;
        }
        try {
            this.buffer = LzmaUtil.compress(this.buffer);
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Couldn't compress lump " + this, ex);
        }
        this.setCompressed(true);
    }

    public void uncompress() {
        if (!this.compressed) {
            return;
        }
        try {
            this.buffer = LzmaUtil.uncompress(this.buffer);
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Couldn't uncompress lump " + this, ex);
        }
        this.setCompressed(false);
    }

    protected void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public abstract String getName();

    public String toString() {
        return this.getName();
    }
}

