/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.entity;

import info.ata4.bsplib.entity.EntityIO;
import info.ata4.bsplib.entity.KeyValue;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.log.LogUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class Entity {
    private static final Logger L = LogUtils.getLogger();
    private Map<String, String> keyValue = new LinkedHashMap<String, String>();
    private List<KeyValue> keyValueIO = new ArrayList<KeyValue>();
    private String className;

    public Entity(String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        if (className.length() == 0) {
            throw new IllegalArgumentException("Empty class name");
        }
        this.className = className;
    }

    public Entity(List<KeyValue> kvList) {
        for (KeyValue kv : kvList) {
            String key = kv.getKey();
            String value = kv.getValue();
            if (key.equals("classname")) {
                if (this.className == null) {
                    this.className = value;
                    continue;
                }
                L.log(Level.WARNING, "Found duplicate classname key, ignoring {0}", kv);
                continue;
            }
            if (EntityIO.isEntityIO(kv)) {
                this.keyValueIO.add(kv);
                continue;
            }
            this.keyValue.put(key, value);
        }
        if (this.className == null || this.className.isEmpty()) {
            L.log(Level.WARNING, "Missing or empty class name, using \"unknown_entity\"");
            this.className = "unknown_entity";
        }
    }

    public List<KeyValue> getIO() {
        return this.keyValueIO;
    }

    public Set<String> getKeys() {
        return this.keyValue.keySet();
    }

    public Collection<String> getValues() {
        return this.keyValue.values();
    }

    public Set<Map.Entry<String, String>> getEntrySet() {
        return this.keyValue.entrySet();
    }

    public boolean hasKey(String key) {
        return this.keyValue.containsKey(key);
    }

    public String getValue(String key) {
        return this.keyValue.get(key);
    }

    public void setValue(String key, Object value) {
        this.keyValue.put(key, String.valueOf(value));
    }

    public void setValue(KeyValue kv) {
        this.setValue(kv.getKey(), kv.getValue());
    }

    public void removeValue(String key) {
        this.keyValue.remove(key);
    }

    public void clear() {
        this.keyValue.clear();
        this.keyValueIO.clear();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getTargetName() {
        return this.getValue("targetname");
    }

    public void setTargetName(String value) {
        this.setValue("targetname", value);
    }

    public Vector3f getVector3f(String key) {
        String str = this.getValue(key);
        if (str == null) {
            return null;
        }
        try {
            String[] costr = StringUtils.split(str, ' ');
            float x = costr.length > 0 ? Float.parseFloat(costr[0]) : 0.0f;
            float y = costr.length > 1 ? Float.parseFloat(costr[1]) : 0.0f;
            float z = costr.length > 2 ? Float.parseFloat(costr[2]) : 0.0f;
            return new Vector3f(x, y, z);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public void setVector3f(String key, Vector3f value) {
        this.setValue(key, value.x + " " + value.y + " " + value.z);
    }

    public Vector3f getOrigin() {
        return this.getVector3f("origin");
    }

    public void setOrigin(Vector3f origin) {
        this.setVector3f("origin", origin);
    }

    public Vector3f getAngles() {
        Vector3f a = this.getVector3f("angles");
        if (a == null) {
            return null;
        }
        return new Vector3f(a.z, -a.x, a.y);
    }

    public void setAngles(Vector3f a) {
        this.setVector3f("angles", new Vector3f(a.z, -a.x, a.y));
    }

    public int getModelNum() {
        String model = this.getValue("model");
        if (model == null) {
            return -1;
        }
        if (model.startsWith("*")) {
            try {
                return Integer.parseInt(model.substring(1));
            }
            catch (NumberFormatException ex) {
                return -2;
            }
        }
        if (model.length() == 0) {
            return 0;
        }
        return -2;
    }

    public void setModelNum(int modelnum) {
        this.setValue("model", "*" + modelnum);
    }

    public void dump(PrintStream ps) {
        ps.println(this.getClassName() + ":");
        for (String key : this.keyValue.keySet()) {
            String value = this.keyValue.get(key);
            if (key.equals("classname")) continue;
            ps.println("  " + key + " = " + value);
        }
        for (KeyValue kv : this.keyValueIO) {
            ps.println("  " + kv.getKey() + ": " + kv.getValue());
        }
        ps.println();
    }

    public void dump() {
        this.dump(System.out);
    }

    public String toString() {
        return this.getClassName() + (this.getTargetName() == null ? "" : " (" + this.getTargetName() + ")");
    }
}

