/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.app;

import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.app.SourceAppHandler;
import info.ata4.log.LogUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SourceAppDB {
    private static final Logger L = LogUtils.getLogger();
    private static SourceAppDB instance;
    private List<SourceApp> appList = new ArrayList<SourceApp>();
    private Map<Integer, SourceApp> appMap = new HashMap<Integer, SourceApp>();
    private float score;

    public static SourceAppDB getInstance() {
        if (instance == null) {
            instance = new SourceAppDB();
        }
        return instance;
    }

    private SourceAppDB() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try (InputStream is = this.getClass().getResourceAsStream("appdb.xml");){
            SAXParser sp = spf.newSAXParser();
            SourceAppHandler handler = new SourceAppHandler();
            sp.parse(is, (DefaultHandler)handler);
            this.appList = handler.getAppList();
            for (SourceApp app : this.appList) {
                Integer appID = app.getAppID();
                if (this.appMap.containsKey(appID)) {
                    L.log(Level.WARNING, "Duplicate App ID {0} for \"{1}\" and \"{2}\"", new Object[]{appID, this.appMap.get(appID), app});
                }
                this.appMap.put(appID, app);
            }
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Can't load Source application database", ex);
        }
    }

    public SourceApp fromID(int appID) {
        if (this.appMap == null || !this.appMap.containsKey(appID)) {
            return SourceApp.UNKNOWN;
        }
        return this.appMap.get(appID);
    }

    public SourceApp find(String bspName, int bspVersion, Set<String> classNames) {
        SourceApp candidate = SourceApp.UNKNOWN;
        this.score = 0.0f;
        if (this.appList == null) {
            return candidate;
        }
        for (SourceApp app : this.appList) {
            if (app.canCheckVersion() && !app.checkVersion(bspVersion)) continue;
            L.log(Level.FINER, "Testing {0}", app.getName());
            float scoreNew = 0.0f;
            if (app.canCheckEntities()) {
                scoreNew += app.checkEntities(classNames);
            }
            if (app.canCheckName()) {
                scoreNew += app.checkName(bspName);
            }
            if (scoreNew == 0.0f || !(scoreNew > this.score)) continue;
            L.log(Level.FINER, "New candidate {0} with a score of {1}", new Object[]{app.getName(), Float.valueOf(scoreNew)});
            candidate = app;
            this.score = scoreNew;
        }
        return candidate;
    }

    public float getScore() {
        return this.score;
    }

    public List<SourceApp> getAppList() {
        return Collections.unmodifiableList(this.appList);
    }
}

