/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib.app;

import info.ata4.log.LogUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SourceApp {
    private static final Logger L = LogUtils.getLogger();
    public static final SourceApp UNKNOWN = new SourceApp("Unknown", 0);
    private final String name;
    private final int appID;
    private int versionMin = -1;
    private int versionMax = -1;
    private String filePattern;
    private Pattern filePatternCompiled;
    private Set<String> entities = new HashSet<String>();
    private float pointsEntities = 20.0f;
    private float pointsFilePattern = 3.0f;

    public SourceApp(String name, int appID) {
        this.name = name;
        this.appID = appID;
    }

    float getPointsEntities() {
        return this.pointsEntities;
    }

    void setPointsEntities(float pointsEntities) {
        this.pointsEntities = pointsEntities;
    }

    float getPointsFilePattern() {
        return this.pointsFilePattern;
    }

    void setPointsFilePattern(float pointsFilePattern) {
        this.pointsFilePattern = pointsFilePattern;
    }

    public String getName() {
        return this.name;
    }

    public int getAppID() {
        return this.appID;
    }

    public URI getSteamStoreURI() {
        if (this == UNKNOWN || this.appID < 0) {
            return null;
        }
        try {
            return new URI(String.format("http://store.steampowered.com/app/%d/", this.appID));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        try {
            this.filePatternCompiled = Pattern.compile(filePattern);
            this.filePattern = filePattern;
        }
        catch (PatternSyntaxException ex) {
            L.log(Level.WARNING, "Invalid file name pattern", ex);
        }
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public int getVersionMin() {
        return this.versionMin;
    }

    public void setVersionMin(int versionMin) {
        this.versionMin = versionMin;
    }

    public int getVersionMax() {
        return this.versionMax;
    }

    public void setVersionMax(int versionMax) {
        this.versionMax = versionMax;
    }

    public boolean canCheckName() {
        return this.filePatternCompiled != null;
    }

    public float checkName(String name) {
        if (!this.canCheckName()) {
            throw new UnsupportedOperationException();
        }
        if (this.filePatternCompiled.matcher(name.toLowerCase(Locale.ROOT)).find()) {
            L.log(Level.FINER, "File pattern match: {0} on {1}", new Object[]{this.filePattern, name});
            return this.pointsFilePattern;
        }
        return 0.0f;
    }

    public boolean canCheckVersion() {
        return this.versionMin != -1 || this.versionMax != -1;
    }

    public boolean checkVersion(int bspVersion) {
        if (!this.canCheckVersion()) {
            throw new UnsupportedOperationException();
        }
        if (this.versionMin != -1 && this.versionMax == -1) {
            return bspVersion == this.versionMin;
        }
        if (this.versionMax != -1 && this.versionMin == -1) {
            return bspVersion == this.versionMax;
        }
        return bspVersion <= this.versionMax && bspVersion >= this.versionMin;
    }

    public boolean canCheckEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    public float checkEntities(Set<String> classNames) {
        if (!this.canCheckEntities()) {
            throw new UnsupportedOperationException();
        }
        int matches = 0;
        for (String className : classNames) {
            if (!this.entities.contains(className)) continue;
            L.log(Level.FINER, "Entity match: {0}", className);
            ++matches;
        }
        return (float)matches / (float)this.entities.size() * this.pointsEntities;
    }

    public String toString() {
        return this.name;
    }
}

