/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib;

import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.io.LzmaUtil;
import info.ata4.bsplib.lump.Lump;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bspsrc.modules.texture.TextureSource;
import info.ata4.io.buffer.ByteBufferChannel;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.tukaani.xz.LZMAInputStream;

public class PakFile {
    private static final Logger L = LogUtils.getLogger();
    private static Pattern vhvPattern = Pattern.compile("sp(_hdr)?_\\d+\\.vhv");
    private static Pattern cubemapVtfPattern = Pattern.compile("c(-?\\d+)_(-?\\d+)_(-?\\d+)(\\.hdr)?\\.vtf");
    private final Lump pakLump;

    public PakFile(BspFile bspFile) {
        this.pakLump = bspFile.getLump(LumpType.LUMP_PAKFILE);
    }

    public ZipFile getZipFile() throws IOException {
        return new ZipFile(new ByteBufferChannel(this.pakLump.getBuffer()), "PakLump", "Cp437", false);
    }

    public void unpack(Path dest) throws IOException {
        this.unpack(dest, false);
    }

    public void unpack(Path dest, boolean direct) throws IOException {
        if (direct) {
            L.log(Level.INFO, "Extracting pakfile to {0}", dest);
            try (InputStream is = this.pakLump.getInputStream();){
                Files.copy(is, dest, new CopyOption[0]);
            }
        } else {
            this.unpack(dest, s -> true);
        }
    }

    public void unpack(Path dest, Predicate<String> fileFilter) throws IOException {
        Files.createDirectories(dest, new FileAttribute[0]);
        try (ZipFile zipFile = this.getZipFile();){
            Enumeration<ZipArchiveEntry> enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry ze = enumeration.nextElement();
                String entryName = ze.getName();
                if (!fileFilter.test(entryName)) continue;
                Path entryFile = dest.resolve(entryName).normalize();
                if (!entryFile.startsWith(dest)) {
                    L.log(Level.WARNING, "Skipped {0} (path traversal attempt)", entryName);
                    continue;
                }
                if (Files.exists(entryFile, new LinkOption[0])) {
                    L.log(Level.WARNING, "Skipped {0} (exists)", entryName);
                    continue;
                }
                if (zipFile.canReadEntryData(ze)) {
                    InputStream stream = zipFile.getInputStream(ze);
                    try {
                        PakFile.extract(stream, entryFile, entryName);
                        continue;
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                        continue;
                    }
                }
                if (ZipMethod.getMethodByCode(ze.getMethod()) == ZipMethod.LZMA) {
                    InputStream rawStream = zipFile.getRawInputStream(ze);
                    try {
                        long uncompressedSize = (ze.getRawFlag() & 2) != 0 ? -1L : ze.getSize();
                        LZMAInputStream lzmaStream = LzmaUtil.fromZipEntry(rawStream, uncompressedSize);
                        try {
                            PakFile.extract(lzmaStream, entryFile, entryName);
                            continue;
                        }
                        finally {
                            if (lzmaStream != null) {
                                lzmaStream.close();
                            }
                            continue;
                        }
                    }
                    finally {
                        if (rawStream == null) continue;
                        rawStream.close();
                        continue;
                    }
                }
                L.warning(String.format("Cannot extract unsupported: %s| method: %s(%s)| encryption: %b", new Object[]{entryName, ZipMethod.getMethodByCode(ze.getMethod()), ze.getMethod(), ze.getGeneralPurposeBit().usesEncryption()}));
            }
        }
    }

    private static void extract(InputStream stream, Path path, String entryName) throws IOException {
        L.log(Level.INFO, "Extracting {0}", entryName);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.copy(stream, path, new CopyOption[0]);
    }

    public static boolean isVBSPGeneratedFile(String bspFileName, String embeddedFileName) {
        return TextureSource.isPatchedMaterial(bspFileName).or(fileName -> vhvPattern.matcher((CharSequence)fileName).find() || cubemapVtfPattern.matcher((CharSequence)fileName).find() || fileName.equalsIgnoreCase("cubemapdefault.vtf") || fileName.equalsIgnoreCase("cubemapdefault.hdr.vtf")).test(embeddedFileName);
    }
}

