/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib;

import info.ata4.bsplib.BspException;
import info.ata4.bsplib.BspFile;
import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.app.SourceAppDB;
import info.ata4.bsplib.entity.Entity;
import info.ata4.bsplib.io.EntityInputStream;
import info.ata4.bsplib.lump.AbstractLump;
import info.ata4.bsplib.lump.GameLump;
import info.ata4.bsplib.lump.Lump;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bsplib.struct.BspData;
import info.ata4.bsplib.struct.DAreaportal;
import info.ata4.bsplib.struct.DAreaportalVin;
import info.ata4.bsplib.struct.DBrush;
import info.ata4.bsplib.struct.DBrushSide;
import info.ata4.bsplib.struct.DBrushSideV2;
import info.ata4.bsplib.struct.DBrushSideVin;
import info.ata4.bsplib.struct.DCubemapSample;
import info.ata4.bsplib.struct.DDispInfo;
import info.ata4.bsplib.struct.DDispInfoBSP17;
import info.ata4.bsplib.struct.DDispInfoBSP22;
import info.ata4.bsplib.struct.DDispInfoBSP23;
import info.ata4.bsplib.struct.DDispInfoVin;
import info.ata4.bsplib.struct.DDispMultiBlend;
import info.ata4.bsplib.struct.DDispTri;
import info.ata4.bsplib.struct.DDispVert;
import info.ata4.bsplib.struct.DEdge;
import info.ata4.bsplib.struct.DEdgeVin;
import info.ata4.bsplib.struct.DFace;
import info.ata4.bsplib.struct.DFaceBSP17;
import info.ata4.bsplib.struct.DFaceBSP18;
import info.ata4.bsplib.struct.DFaceVTMB;
import info.ata4.bsplib.struct.DFaceVinV1;
import info.ata4.bsplib.struct.DFaceVinV2;
import info.ata4.bsplib.struct.DLeafV0;
import info.ata4.bsplib.struct.DLeafV1;
import info.ata4.bsplib.struct.DLeafVin;
import info.ata4.bsplib.struct.DModel;
import info.ata4.bsplib.struct.DModelDM;
import info.ata4.bsplib.struct.DNode;
import info.ata4.bsplib.struct.DNodeVin;
import info.ata4.bsplib.struct.DOccluderData;
import info.ata4.bsplib.struct.DOccluderDataV1;
import info.ata4.bsplib.struct.DOccluderPolyData;
import info.ata4.bsplib.struct.DOverlay;
import info.ata4.bsplib.struct.DOverlayDota2;
import info.ata4.bsplib.struct.DOverlayFade;
import info.ata4.bsplib.struct.DOverlaySystemLevel;
import info.ata4.bsplib.struct.DOverlayVin;
import info.ata4.bsplib.struct.DPlane;
import info.ata4.bsplib.struct.DPrimitive;
import info.ata4.bsplib.struct.DStaticProp;
import info.ata4.bsplib.struct.DStaticPropV10;
import info.ata4.bsplib.struct.DStaticPropV10CSGO;
import info.ata4.bsplib.struct.DStaticPropV11;
import info.ata4.bsplib.struct.DStaticPropV11CSGO;
import info.ata4.bsplib.struct.DStaticPropV11lite;
import info.ata4.bsplib.struct.DStaticPropV4;
import info.ata4.bsplib.struct.DStaticPropV5Ship;
import info.ata4.bsplib.struct.DStaticPropV6BGT;
import info.ata4.bsplib.struct.DStaticPropV6DM;
import info.ata4.bsplib.struct.DStaticPropV6VIN;
import info.ata4.bsplib.struct.DStaticPropV7L4D;
import info.ata4.bsplib.struct.DStaticPropV7VIN;
import info.ata4.bsplib.struct.DStaticPropV7ZC;
import info.ata4.bsplib.struct.DStaticPropV9DE;
import info.ata4.bsplib.struct.DStaticPropVinScaling;
import info.ata4.bsplib.struct.DStruct;
import info.ata4.bsplib.struct.DTexData;
import info.ata4.bsplib.struct.DTexInfo;
import info.ata4.bsplib.struct.DTexInfoDM;
import info.ata4.bsplib.struct.DVertex;
import info.ata4.bsplib.struct.LevelFlag;
import info.ata4.bsplib.vector.Vector3f;
import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import info.ata4.io.Seekable;
import info.ata4.log.LogUtils;
import info.ata4.util.EnumConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BspFileReader {
    private static final Logger L = LogUtils.getLogger();
    private final BspFile bspFile;
    private final BspData bspData;
    private int appID;
    private Set<String> entityClasses = new TreeSet<String>();

    public BspFileReader(BspFile bspFile, BspData bspData) throws IOException {
        this.bspFile = bspFile;
        this.bspData = bspData;
        this.appID = bspFile.getSourceApp().getAppID();
        if (bspFile.getFile() == null) {
            throw new BspException("BSP file is unloaded");
        }
        if (bspFile.isCompressed()) {
            bspFile.uncompress();
        }
    }

    public BspFileReader(BspFile bspFile) throws IOException {
        this(bspFile, new BspData());
    }

    public void loadAll() {
        this.loadEntities();
        this.loadVertices();
        this.loadEdges();
        this.loadFaces();
        this.loadOriginalFaces();
        this.loadModels();
        this.loadSurfaceEdges();
        this.loadOccluders();
        this.loadTexInfo();
        this.loadTexData();
        this.loadStaticProps();
        this.loadCubemaps();
        this.loadPlanes();
        this.loadBrushes();
        this.loadBrushSides();
        this.loadAreaportals();
        this.loadClipPortalVertices();
        this.loadDispInfos();
        this.loadDispVertices();
        this.loadDispTriangleTags();
        this.loadDispMultiBlend();
        this.loadNodes();
        this.loadLeaves();
        this.loadLeafFaces();
        this.loadLeafBrushes();
        this.loadOverlays();
        this.loadFlags();
    }

    public void loadPlanes() {
        if (this.bspData.planes != null) {
            return;
        }
        this.bspData.planes = this.loadLump(LumpType.LUMP_PLANES, DPlane.class);
    }

    public void loadBrushes() {
        if (this.bspData.brushes != null) {
            return;
        }
        this.bspData.brushes = this.loadLump(LumpType.LUMP_BRUSHES, DBrush.class);
    }

    public void loadBrushSides() {
        if (this.bspData.brushSides != null) {
            return;
        }
        Class<DBrushSide> struct = DBrushSide.class;
        if (this.appID == -100) {
            struct = DBrushSideVin.class;
        } else if (this.bspFile.getVersion() >= 21 && this.appID != 550) {
            struct = DBrushSideV2.class;
        }
        this.bspData.brushSides = this.loadLump(LumpType.LUMP_BRUSHSIDES, struct);
    }

    public void loadVertices() {
        if (this.bspData.verts != null) {
            return;
        }
        this.bspData.verts = this.loadLump(LumpType.LUMP_VERTEXES, DVertex.class);
    }

    public void loadClipPortalVertices() {
        if (this.bspData.clipPortalVerts != null) {
            return;
        }
        this.bspData.clipPortalVerts = this.loadLump(LumpType.LUMP_CLIPPORTALVERTS, DVertex.class);
    }

    public void loadEdges() {
        if (this.bspData.edges != null) {
            return;
        }
        Class<DEdge> struct = DEdge.class;
        if (this.appID == -100) {
            struct = DEdgeVin.class;
        }
        this.bspData.edges = this.loadLump(LumpType.LUMP_EDGES, struct);
    }

    private void loadFaces(boolean orig) {
        if (orig && this.bspData.origFaces != null || !orig && this.bspData.faces != null) {
            return;
        }
        Class<DFace> struct = DFace.class;
        block0 : switch (this.appID) {
            case 2600: {
                struct = DFaceVTMB.class;
                break;
            }
            case -100: {
                LumpType lt = orig ? LumpType.LUMP_ORIGINALFACES : LumpType.LUMP_FACES;
                int facesver = this.getLump(lt).getVersion();
                if (facesver == 2) {
                    struct = DFaceVinV2.class;
                    break;
                }
                struct = DFaceVinV1.class;
                break;
            }
            default: {
                switch (this.bspFile.getVersion()) {
                    case 17: {
                        struct = DFaceBSP17.class;
                        break block0;
                    }
                    case 18: {
                        struct = DFaceBSP18.class;
                    }
                }
            }
        }
        if (orig) {
            this.bspData.origFaces = this.loadLump(LumpType.LUMP_ORIGINALFACES, struct);
        } else {
            this.bspData.faces = this.getLump(LumpType.LUMP_FACES).getLength() == 0 ? this.loadLump(LumpType.LUMP_FACES_HDR, struct) : this.loadLump(LumpType.LUMP_FACES, struct);
        }
    }

    public void loadFaces() {
        this.loadFaces(false);
    }

    public void loadOriginalFaces() {
        this.loadFaces(true);
    }

    public void loadModels() {
        if (this.bspData.models != null) {
            return;
        }
        Class<DModel> struct = DModel.class;
        if (this.appID == 2100) {
            struct = DModelDM.class;
        }
        this.bspData.models = this.loadLump(LumpType.LUMP_MODELS, struct);
    }

    public void loadSurfaceEdges() {
        if (this.bspData.surfEdges != null) {
            return;
        }
        this.bspData.surfEdges = this.loadIntegerLump(LumpType.LUMP_SURFEDGES);
    }

    public void loadStaticProps() {
        if (this.bspData.staticProps != null && this.bspData.staticPropName != null) {
            return;
        }
        L.fine("Loading static props");
        GameLump sprpLump = this.bspFile.getGameLump("sprp");
        if (sprpLump == null) {
            this.bspData.staticProps = new ArrayList<DStaticProp>();
            return;
        }
        DataReader in = DataReaders.forByteBuffer(sprpLump.getBuffer());
        int sprpver = sprpLump.getVersion();
        try {
            int propStaticSizeActual;
            int propStaticCount;
            int padsize = 128;
            int psnames = in.readInt();
            L.log(Level.FINE, "Static prop names: {0}", psnames);
            this.bspData.staticPropName = new ArrayList<String>(psnames);
            for (int i = 0; i < psnames; ++i) {
                this.bspData.staticPropName.add(in.readStringFixed(128));
            }
            if (this.appID == 22200) {
                int psextra = in.readInt();
                in.seek(psextra * 128, Seekable.Origin.CURRENT);
            }
            int propleaves = in.readInt();
            L.log(Level.FINE, "Static prop leaves: {0}", propleaves);
            this.bspData.staticPropLeaf = new ArrayList<Integer>(propleaves);
            for (int i = 0; i < propleaves; ++i) {
                this.bspData.staticPropLeaf.add(in.readUnsignedShort());
            }
            HashMap<Integer, Vector3f> scaling = new HashMap<Integer, Vector3f>();
            if (this.appID == -100 && sprpver > 5) {
                int scalingCount = in.readInt();
                for (int i = 0; i < scalingCount; ++i) {
                    scaling.put(in.readInt(), Vector3f.read(in));
                }
            }
            if ((propStaticCount = in.readInt()) == 0) {
                this.bspData.staticProps = Collections.emptyList();
                return;
            }
            int propStaticSize = (int)in.remaining() / propStaticCount;
            Class structClass = null;
            switch (this.appID) {
                case 2400: {
                    if (propStaticSize != 188) break;
                    structClass = DStaticPropV5Ship.class;
                    break;
                }
                case 2450: {
                    if (propStaticSize != 192) break;
                    structClass = DStaticPropV6BGT.class;
                    break;
                }
                case 22200: {
                    if (propStaticSize != 68) break;
                    structClass = DStaticPropV7ZC.class;
                    break;
                }
                case 2100: {
                    if (propStaticSize != 136) break;
                    structClass = DStaticPropV6DM.class;
                    break;
                }
                case 203810: {
                    if (propStaticSize != 76) break;
                    structClass = DStaticPropV9DE.class;
                    break;
                }
                case -100: {
                    if (sprpver == 6 && propStaticSize == 60) {
                        structClass = DStaticPropV6VIN.class;
                        break;
                    }
                    if (sprpver != 7 || propStaticSize != 64) break;
                    structClass = DStaticPropV7VIN.class;
                    break;
                }
                case 500: {
                    if (sprpver != 7 || propStaticSize != 68) break;
                    structClass = DStaticPropV7L4D.class;
                    break;
                }
                case 440: {
                    if (sprpver != 7 || propStaticSize != 72) break;
                    structClass = DStaticPropV10.class;
                    break;
                }
                case 730: {
                    if (sprpver == 10) {
                        structClass = DStaticPropV10CSGO.class;
                        break;
                    }
                    if (sprpver != 11) break;
                    structClass = DStaticPropV11CSGO.class;
                    break;
                }
                case 362890: {
                    if (sprpver == 10 && propStaticSize == 72) {
                        structClass = DStaticPropV10.class;
                        break;
                    }
                    if (sprpver != 11) break;
                    if (propStaticSize == 76) {
                        structClass = DStaticPropV11lite.class;
                        break;
                    }
                    if (propStaticSize != 80) break;
                    structClass = DStaticPropV11.class;
                    break;
                }
                case 222880: {
                    if (sprpver != 10 || propStaticSize != 76) break;
                    structClass = DStaticPropV10CSGO.class;
                    break;
                }
                default: {
                    if (sprpver != 11 || propStaticSize != 76) break;
                    structClass = DStaticPropV11lite.class;
                }
            }
            if (structClass == null) {
                try {
                    String className = DStaticProp.class.getName();
                    structClass = Class.forName(className + "V" + sprpver);
                }
                catch (ClassNotFoundException ex) {
                    L.log(Level.WARNING, "Couldn''t find static prop struct for version {0}", sprpver);
                    structClass = null;
                }
            }
            if (structClass != null && (propStaticSizeActual = ((DStaticProp)structClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSize()) != propStaticSize) {
                L.log(Level.WARNING, "Static prop struct size mismatch: expected {0}, got {1} (using {2})", new Object[]{propStaticSize, propStaticSizeActual, structClass.getSimpleName()});
                structClass = null;
            }
            int numFillBytes = 0;
            if (structClass == null) {
                L.log(Level.WARNING, "Falling back to static prop v4");
                structClass = DStaticPropV4.class;
                numFillBytes = propStaticSize - 56;
            }
            this.bspData.staticProps = new ArrayList<DStaticProp>(propStaticCount);
            for (int i = 0; i < propStaticCount; ++i) {
                DStaticProp sp = (DStaticProp)structClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                sp.read(in);
                if (numFillBytes > 0) {
                    in.seek(numFillBytes, Seekable.Origin.CURRENT);
                }
                if (scaling.containsKey(i) && sp instanceof DStaticPropVinScaling) {
                    ((DStaticPropVinScaling)((Object)sp)).setScaling((Vector3f)scaling.get(i));
                }
                this.bspData.staticProps.add(sp);
            }
            L.log(Level.FINE, "Static props: {0}", propStaticCount);
            this.checkRemaining(in);
        }
        catch (IOException ex) {
            this.lumpError(sprpLump, ex);
        }
        catch (ReflectiveOperationException ex) {
            L.log(Level.SEVERE, "Lump struct class error", ex);
        }
    }

    public void loadCubemaps() {
        if (this.bspData.cubemaps != null) {
            return;
        }
        this.bspData.cubemaps = this.loadLump(LumpType.LUMP_CUBEMAPS, DCubemapSample.class);
    }

    public void loadDispInfos() {
        if (this.bspData.dispinfos != null) {
            return;
        }
        Class<DDispInfo> struct = DDispInfo.class;
        int bspv = this.bspFile.getVersion();
        switch (this.appID) {
            case -100: {
                struct = DDispInfoVin.class;
                break;
            }
            case 220: {
                if (bspv != 17) break;
                struct = DDispInfoBSP17.class;
                break;
            }
            case 570: {
                if (bspv == 22) {
                    struct = DDispInfoBSP22.class;
                    break;
                }
                if (bspv < 23) break;
                struct = DDispInfoBSP23.class;
            }
        }
        this.bspData.dispinfos = this.loadLump(LumpType.LUMP_DISPINFO, struct);
    }

    public void loadDispVertices() {
        if (this.bspData.dispverts != null) {
            return;
        }
        this.bspData.dispverts = this.loadLump(LumpType.LUMP_DISP_VERTS, DDispVert.class);
    }

    public void loadDispTriangleTags() {
        if (this.bspData.disptris != null) {
            return;
        }
        this.bspData.disptris = this.loadLump(LumpType.LUMP_DISP_TRIS, DDispTri.class);
    }

    public void loadDispMultiBlend() {
        if (this.bspData.dispmultiblend != null) {
            return;
        }
        LumpType lumpType = this.appID == 362890 ? LumpType.LUMP_OVERLAY_SYSTEM_LEVELS : LumpType.LUMP_DISP_MULTIBLEND;
        this.bspData.dispmultiblend = this.loadLump(lumpType, DDispMultiBlend.class);
    }

    public void loadTexInfo() {
        if (this.bspData.texinfos != null) {
            return;
        }
        Class<DTexInfo> struct = DTexInfo.class;
        if (this.appID == 2100) {
            struct = DTexInfoDM.class;
        }
        this.bspData.texinfos = this.loadLump(LumpType.LUMP_TEXINFO, struct);
    }

    public void loadTexData() {
        if (this.bspData.texdatas != null) {
            return;
        }
        this.bspData.texdatas = this.loadLump(LumpType.LUMP_TEXDATA, DTexData.class);
        this.loadTexDataStrings();
    }

    private void loadTexDataStrings() {
        byte[] stringData;
        L.log(Level.FINE, "Loading {0}", (Object)LumpType.LUMP_TEXDATA_STRING_DATA);
        Lump lump = this.getLump(LumpType.LUMP_TEXDATA_STRING_DATA);
        DataReader in = DataReaders.forByteBuffer(lump.getBuffer());
        try {
            int tdsds = lump.getLength();
            stringData = new byte[tdsds];
            in.readBytes(stringData);
            this.checkRemaining(in);
        }
        catch (IOException ex) {
            this.lumpError(lump, ex);
            return;
        }
        L.log(Level.FINE, "Loading {0}", (Object)LumpType.LUMP_TEXDATA_STRING_TABLE);
        lump = this.getLump(LumpType.LUMP_TEXDATA_STRING_TABLE);
        in = DataReaders.forByteBuffer(lump.getBuffer());
        try {
            int size = 4;
            int tdsts = lump.getLength() / 4;
            this.bspData.texnames = new ArrayList<String>(tdsts);
            block4: for (int i = 0; i < tdsts; ++i) {
                int ofs;
                for (int ofsNull = ofs = in.readInt(); ofsNull < stringData.length; ++ofsNull) {
                    if (stringData[ofsNull] != 0) continue;
                    this.bspData.texnames.add(new String(stringData, ofs, ofsNull - ofs));
                    continue block4;
                }
            }
            L.log(Level.FINE, "Texture data strings: {0}", tdsts);
            this.checkRemaining(in);
        }
        catch (IOException ex) {
            this.lumpError(lump, ex);
        }
    }

    public void loadEntities() {
        if (this.bspData.entities != null) {
            return;
        }
        L.log(Level.FINE, "Loading {0}", (Object)LumpType.LUMP_ENTITIES);
        Lump lump = this.getLump(LumpType.LUMP_ENTITIES);
        try (EntityInputStream entReader = new EntityInputStream(lump.getInputStream());){
            Entity ent;
            entReader.setAllowEscSeq(this.bspFile.getVersion() == 17);
            this.bspData.entities = new ArrayList<Entity>();
            this.entityClasses.clear();
            while ((ent = entReader.readEntity()) != null) {
                this.bspData.entities.add(ent);
                this.entityClasses.add(ent.getClassName());
            }
            if (this.appID == 0) {
                SourceAppDB appDB = SourceAppDB.getInstance();
                SourceApp app = appDB.find(this.bspFile.getName(), this.bspFile.getVersion(), this.entityClasses);
                this.bspFile.setSourceApp(app);
                this.appID = app.getAppID();
            }
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Couldn''t read entity lump", ex);
        }
        L.log(Level.FINE, "Entities: {0}", this.bspData.entities.size());
    }

    public void loadNodes() {
        if (this.bspData.nodes != null) {
            return;
        }
        Class<DNode> struct = DNode.class;
        if (this.appID == -100) {
            struct = DNodeVin.class;
        }
        this.bspData.nodes = this.loadLump(LumpType.LUMP_NODES, struct);
    }

    public void loadLeaves() {
        if (this.bspData.leaves != null) {
            return;
        }
        Class struct = DLeafV1.class;
        if (this.appID == -100) {
            struct = DLeafVin.class;
        } else if (this.getLump(LumpType.LUMP_LEAFS).getVersion() == 0 && this.bspFile.getVersion() == 19) {
            struct = DLeafV0.class;
        }
        this.bspData.leaves = this.loadLump(LumpType.LUMP_LEAFS, struct);
    }

    public void loadLeafFaces() {
        if (this.bspData.leafFaces != null) {
            return;
        }
        this.bspData.leafFaces = this.loadIntegerLump(LumpType.LUMP_LEAFFACES, this.appID != -100);
    }

    public void loadLeafBrushes() {
        if (this.bspData.leafBrushes != null) {
            return;
        }
        this.bspData.leafBrushes = this.loadIntegerLump(LumpType.LUMP_LEAFBRUSHES, this.appID != -100);
    }

    public void loadOverlays() {
        if (this.bspData.overlays != null) {
            return;
        }
        Class<DOverlay> struct = DOverlay.class;
        if (this.appID == -100) {
            struct = DOverlayVin.class;
        } else if (this.appID == 570) {
            struct = DOverlayDota2.class;
        }
        this.bspData.overlays = this.loadLump(LumpType.LUMP_OVERLAYS, struct);
        if (this.bspData.overlayFades == null) {
            this.bspData.overlayFades = this.loadLump(LumpType.LUMP_OVERLAY_FADES, DOverlayFade.class);
        }
        if (this.bspData.overlaySysLevels == null) {
            this.bspData.overlaySysLevels = this.appID == 362890 ? Collections.emptyList() : this.loadLump(LumpType.LUMP_OVERLAY_SYSTEM_LEVELS, DOverlaySystemLevel.class);
        }
    }

    public void loadAreaportals() {
        if (this.bspData.areaportals != null) {
            return;
        }
        Class<DAreaportal> struct = DAreaportal.class;
        if (this.appID == -100) {
            struct = DAreaportalVin.class;
        }
        this.bspData.areaportals = this.loadLump(LumpType.LUMP_AREAPORTALS, struct);
    }

    public void loadOccluders() {
        if (this.bspData.occluderDatas != null) {
            return;
        }
        L.log(Level.FINE, "Loading {0}", (Object)LumpType.LUMP_OCCLUSION);
        Lump lump = this.getLump(LumpType.LUMP_OCCLUSION);
        DataReader in = DataReaders.forByteBuffer(lump.getBuffer());
        try {
            int occluders = lump.getLength() == 0 ? 0 : in.readInt();
            this.bspData.occluderDatas = new ArrayList<DOccluderData>(occluders);
            for (int i = 0; i < occluders; ++i) {
                int lumpVersion = lump.getVersion();
                if (this.bspFile.getSourceApp().getAppID() == 238430) {
                    lumpVersion = 1;
                }
                DOccluderData od = lumpVersion > 0 ? new DOccluderDataV1() : new DOccluderData();
                od.read(in);
                this.bspData.occluderDatas.add(od);
            }
            L.log(Level.FINE, "Occluders: {0}", occluders);
            int occluderPolys = lump.getLength() == 0 ? 0 : in.readInt();
            this.bspData.occluderPolyDatas = new ArrayList<DOccluderPolyData>(occluderPolys);
            for (int i = 0; i < occluderPolys; ++i) {
                DOccluderPolyData opd = new DOccluderPolyData();
                opd.read(in);
                this.bspData.occluderPolyDatas.add(opd);
            }
            L.log(Level.FINE, "Occluder polygons: {0}", occluderPolys);
            int occluderVertices = lump.getLength() == 0 ? 0 : in.readInt();
            this.bspData.occluderVerts = new ArrayList<Integer>(occluderVertices);
            for (int i = 0; i < occluderVertices; ++i) {
                this.bspData.occluderVerts.add(in.readInt());
            }
            L.log(Level.FINE, "Occluder vertices: {0}", occluderVertices);
            this.checkRemaining(in);
        }
        catch (IOException ex) {
            this.lumpError(lump, ex);
        }
    }

    public void loadFlags() {
        if (this.bspData.mapFlags != null) {
            return;
        }
        L.log(Level.FINE, "Loading {0}", (Object)LumpType.LUMP_MAP_FLAGS);
        Lump lump = this.getLump(LumpType.LUMP_MAP_FLAGS);
        if (lump.getLength() == 0) {
            return;
        }
        DataReader in = DataReaders.forByteBuffer(lump.getBuffer());
        try {
            this.bspData.mapFlags = EnumConverter.fromInteger(LevelFlag.class, in.readInt());
            L.log(Level.FINE, "Map flags: {0}", this.bspData.mapFlags);
            this.checkRemaining(in);
        }
        catch (IOException ex) {
            this.lumpError(lump, ex);
        }
    }

    public void loadPrimitives() {
        if (this.bspData.prims != null) {
            return;
        }
        this.bspData.prims = this.loadLump(LumpType.LUMP_PRIMITIVES, DPrimitive.class);
    }

    public void loadPrimIndices() {
        if (this.bspData.primIndices != null) {
            return;
        }
        this.bspData.primIndices = this.loadIntegerLump(LumpType.LUMP_PRIMINDICES, true);
    }

    public void loadPrimVerts() {
        if (this.bspData.primVerts != null) {
            return;
        }
        this.bspData.primVerts = this.loadLump(LumpType.LUMP_PRIMVERTS, DVertex.class);
    }

    private <E extends DStruct> List<E> loadLump(LumpType lumpType, Class<E> struct) {
        if (!this.bspFile.canReadLump(lumpType)) {
            return Collections.emptyList();
        }
        Lump lump = this.getLump(lumpType);
        if (lump.getLength() == 0) {
            return Collections.emptyList();
        }
        L.log(Level.FINE, "Loading {0}", (Object)lumpType);
        DataReader in = DataReaders.forByteBuffer(lump.getBuffer());
        try {
            int structSize = ((DStruct)struct.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSize();
            int packetCount = lump.getLength() / structSize;
            ArrayList<DStruct> packets = new ArrayList<DStruct>(packetCount);
            for (int i = 0; i < packetCount; ++i) {
                DStruct packet = (DStruct)struct.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                long pos = in.position();
                packet.read(in);
                if (in.position() - pos != (long)packet.getSize()) {
                    throw new IOException("Bytes read: " + pos + "; expected: " + packet.getSize());
                }
                packets.add(packet);
            }
            this.checkRemaining(in);
            L.log(Level.FINE, "{0} {1} objects", new Object[]{packets.size(), struct.getSimpleName()});
            return packets;
        }
        catch (IOException ex) {
            this.lumpError(lump, ex);
        }
        catch (ReflectiveOperationException ex) {
            L.log(Level.SEVERE, "Lump struct class error", ex);
        }
        return null;
    }

    private List<Integer> loadIntegerLump(LumpType lumpType, boolean unsignedShort) {
        L.log(Level.FINE, "Loading {0}", (Object)lumpType);
        Lump lump = this.getLump(lumpType);
        DataReader in = DataReaders.forByteBuffer(lump.getBuffer());
        try {
            int size = unsignedShort ? 2 : 4;
            int arraySize = lump.getLength() / size;
            ArrayList<Integer> list = new ArrayList<Integer>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                if (unsignedShort) {
                    list.add(in.readUnsignedShort());
                    continue;
                }
                list.add(in.readInt());
            }
            L.log(Level.FINE, "{0} Integer objects", arraySize);
            this.checkRemaining(in);
            return list;
        }
        catch (IOException ex) {
            this.lumpError(lump, ex);
            return null;
        }
    }

    private List<Integer> loadIntegerLump(LumpType lumpType) {
        return this.loadIntegerLump(lumpType, false);
    }

    private void lumpError(AbstractLump lump, IOException ex) {
        L.log(Level.SEVERE, "Lump reading error in " + lump, ex);
    }

    private void checkRemaining(DataReader in) throws IOException {
        if (in.hasRemaining()) {
            throw new IOException(in.remaining() + " bytes remaining");
        }
    }

    private Lump getLump(LumpType type) {
        return this.bspFile.getLump(type);
    }

    public Set<String> getEntityClassSet() {
        return Collections.unmodifiableSet(this.entityClasses);
    }

    public BspFile getBspFile() {
        return this.bspFile;
    }

    public BspData getData() {
        return this.bspData;
    }
}

