/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bsplib;

import info.ata4.bsplib.BspException;
import info.ata4.bsplib.BspFileReader;
import info.ata4.bsplib.PakFile;
import info.ata4.bsplib.app.SourceApp;
import info.ata4.bsplib.app.SourceAppDB;
import info.ata4.bsplib.lump.GameLump;
import info.ata4.bsplib.lump.Lump;
import info.ata4.bsplib.lump.LumpFile;
import info.ata4.bsplib.lump.LumpType;
import info.ata4.bsplib.util.StringMacroUtils;
import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import info.ata4.io.DataWriter;
import info.ata4.io.DataWriters;
import info.ata4.io.Seekable;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.util.XORUtils;
import info.ata4.log.LogUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.FilenameUtils;

public class BspFile {
    private static final Logger L = LogUtils.getLogger();
    public static final int BSP_ID = StringMacroUtils.makeID("VBSP");
    public static final int BSP_ID_TF = StringMacroUtils.makeID("rBSP");
    private ByteOrder bo;
    public static final int HEADER_LUMPS = 64;
    public static final int HEADER_LUMPS_TF = 128;
    public static final int HEADER_SIZE = 1036;
    public static final int MAX_LUMPFILES = 128;
    private Path file;
    private String name;
    private final List<Lump> lumps = new ArrayList<Lump>(64);
    private final List<GameLump> gameLumps = new ArrayList<GameLump>();
    private int version;
    private int mapRev;
    private SourceApp app = SourceApp.UNKNOWN;

    public BspFile() {
    }

    public BspFile(Path file, boolean memMapping) throws IOException {
        this.loadImpl(file, memMapping);
    }

    public BspFile(Path file) throws IOException {
        this.loadImpl(file);
    }

    private void loadImpl(Path file) throws IOException {
        this.load(file);
    }

    private void loadImpl(Path file, boolean memMapping) throws IOException {
        this.load(file, memMapping);
    }

    public void load(Path file, boolean memMapping) throws IOException {
        this.file = file;
        this.name = FilenameUtils.removeExtension(file.getFileName().toString());
        L.log(Level.FINE, "Loading headers from {0}", this.name);
        ByteBuffer bb = this.createBuffer(memMapping);
        L.log(Level.FINER, "Endianness: {0}", this.bo);
        bb.order(this.bo);
        this.version = bb.getInt();
        L.log(Level.FINER, "Version: {0}", this.version);
        if (this.version == 262164) {
            L.finer("Found Dark Messiah header");
            this.app = SourceAppDB.getInstance().fromID(2100);
            this.version &= 0xFF;
        } else if (this.version == 27) {
            L.finer("Found Contagion header");
            this.app = SourceAppDB.getInstance().fromID(238430);
        }
        if (this.version == 21 && bb.getInt(8) == 0) {
            L.finer("Found Left 4 Dead 2 header");
            this.app = SourceAppDB.getInstance().fromID(550);
        }
        if (this.app.getAppID() == 238430) {
            bb.getInt();
        }
        if (this.app.getAppID() == -400) {
            this.mapRev = bb.getInt();
            L.log(Level.FINER, "Map revision: {0}", this.mapRev);
            bb.getInt();
        }
        this.loadLumps(bb);
        this.loadGameLumps();
        if (this.app.getAppID() == -400) {
            this.loadTitanfallLumpFiles();
            this.loadTitanfallEntityFiles();
        } else {
            this.mapRev = bb.getInt();
            L.log(Level.FINER, "Map revision: {0}", this.mapRev);
        }
    }

    public void load(Path file) throws IOException {
        this.load(file, true);
    }

    public void save(Path file) throws IOException {
        this.file = file;
        this.name = file.getFileName().toString();
        L.log(Level.FINE, "Saving headers to {0}", this.name);
        this.saveGameLumps();
        int size = this.fixLumpOffsets();
        MappedByteBuffer bb = ByteBufferUtils.openReadWrite(file, 0, size);
        bb.order(this.bo);
        bb.putInt(BSP_ID);
        bb.putInt(this.version);
        this.saveLumps(bb);
        bb.putInt(this.mapRev);
    }

    private ByteBuffer createBuffer(boolean memMapping) throws IOException, BspException {
        ByteBuffer bb = memMapping ? ByteBufferUtils.openReadOnly(this.file) : ByteBufferUtils.load(this.file);
        if (bb.capacity() < 1036) {
            throw new BspException("Invalid or missing header");
        }
        int ident = bb.getInt();
        if (ident == BSP_ID) {
            this.bo = ByteOrder.BIG_ENDIAN;
            return bb;
        }
        if ((ident = EndianUtils.swapInteger(ident)) == BSP_ID) {
            this.bo = ByteOrder.LITTLE_ENDIAN;
            return bb;
        }
        if (ident == BSP_ID_TF) {
            L.finer("Found Titanfall header");
            this.app = SourceAppDB.getInstance().fromID(-400);
            this.bo = ByteOrder.LITTLE_ENDIAN;
            return bb;
        }
        if (ident == 30) {
            throw new BspException("The GoldSrc format is not supported");
        }
        byte[] mapKey = new byte[32];
        bb.position(384);
        bb.get(mapKey);
        int identXor = XORUtils.xor(ident, mapKey);
        if (identXor == BSP_ID) {
            this.bo = ByteOrder.LITTLE_ENDIAN;
            L.log(Level.FINE, "Found Tactical Intervention XOR encryption using the key \"{0}\"", new String(mapKey));
            if (memMapping || bb.isReadOnly()) {
                bb = ByteBufferUtils.load(this.file);
            }
            XORUtils.xor(bb, mapKey);
            bb.position(4);
            return bb;
        }
        throw new BspException("Unknown file ident: " + ident + " (" + StringMacroUtils.unmakeID(ident) + ")");
    }

    private void loadLumps(ByteBuffer bb) {
        L.fine("Loading lumps");
        int numLumps = this.app.getAppID() == -400 ? 128 : 64;
        for (int i = 0; i < numLumps; ++i) {
            int lenOld;
            int len;
            int ofs;
            int vers;
            if (this.app.getAppID() == 550) {
                vers = bb.getInt();
                ofs = bb.getInt();
                len = bb.getInt();
            } else {
                ofs = bb.getInt();
                len = bb.getInt();
                vers = bb.getInt();
            }
            int fourCC = bb.getInt();
            LumpType ltype = LumpType.get(i, this.version);
            if (ofs > bb.limit()) {
                int ofsOld = ofs;
                ofs = bb.limit();
                len = 0;
                L.log(Level.WARNING, "Invalid lump offset {0} in {1}, assuming {2}", new Object[]{ofsOld, ltype, ofs});
            } else if (ofs < 0) {
                int ofsOld = ofs;
                ofs = 0;
                len = 0;
                L.log(Level.WARNING, "Negative lump offset {0} in {1}, assuming {2}", new Object[]{ofsOld, ltype, ofs});
            }
            if (ofs + len > bb.limit()) {
                lenOld = len;
                len = bb.limit() - ofs;
                L.log(Level.WARNING, "Invalid lump length {0} in {1}, assuming {2}", new Object[]{lenOld, ltype, len});
            } else if (len < 0) {
                lenOld = len;
                len = 0;
                L.log(Level.WARNING, "Negative lump length {0} in {1}, assuming {2}", new Object[]{lenOld, ltype, len});
            }
            Lump l = new Lump(i, ltype);
            l.setBuffer(ByteBufferUtils.getSlice(bb, ofs, len));
            l.setOffset(ofs);
            l.setParentFile(this.file);
            l.setFourCC(fourCC);
            l.setVersion(vers);
            this.lumps.add(l);
        }
    }

    private void saveLumps(ByteBuffer bb) {
        L.fine("Saving lumps");
        for (Lump lump : this.lumps) {
            if (this.app.getAppID() == 550) {
                bb.putInt(lump.getVersion());
                bb.putInt(lump.getOffset());
                bb.putInt(lump.getLength());
            } else {
                bb.putInt(lump.getOffset());
                bb.putInt(lump.getLength());
                bb.putInt(lump.getVersion());
            }
            bb.putInt(lump.getFourCC());
            if (lump.getLength() == 0) continue;
            if (lump.getType() == LumpType.LUMP_GAME_LUMP) {
                this.fixGameLumpOffsets(lump);
            }
            ByteBuffer lbb = lump.getBuffer();
            lbb.rewind();
            bb.mark();
            bb.position(lump.getOffset());
            bb.put(lbb);
            bb.reset();
        }
    }

    public void loadLumpFiles() {
        Path lumpFile;
        L.fine("Loading lump files");
        for (int i = 0; i < 128 && Files.exists(lumpFile = this.file.resolveSibling(String.format("%s_l_%d.lmp", this.name, i)), new LinkOption[0]); ++i) {
            try {
                LumpFile lumpFileExt = new LumpFile(this.version);
                lumpFileExt.load(lumpFile, this.bo);
                Lump l = lumpFileExt.getLump();
                this.lumps.set(l.getIndex(), l);
                if (l.getType() != LumpType.LUMP_GAME_LUMP) continue;
                this.gameLumps.clear();
                this.loadGameLumps();
                continue;
            }
            catch (IOException ex) {
                L.log(Level.WARNING, "Unable to load lump file " + lumpFile.getFileName(), ex);
            }
        }
    }

    private void loadTitanfallLumpFiles() {
        L.fine("Loading Titanfall lump files");
        for (int i = 0; i < 128; ++i) {
            Path lumpFile = this.file.resolveSibling(String.format("%s.bsp.%04x.bsp_lump", this.name, i));
            if (!Files.exists(lumpFile, new LinkOption[0])) continue;
            Lump l = this.lumps.get(i);
            try {
                MappedByteBuffer bb = ByteBufferUtils.openReadOnly(lumpFile);
                bb.order(this.bo);
                l.setBuffer(bb);
                l.setParentFile(lumpFile);
                continue;
            }
            catch (IOException ex) {
                L.log(Level.WARNING, "Unable to load lump file " + lumpFile.getFileName(), ex);
            }
        }
    }

    private void loadTitanfallEntityFiles() {
        L.fine("Loading Titanfall entity files");
        Lump entlump = this.getLump(LumpType.LUMP_ENTITIES);
        ByteBuffer bbEnt = entlump.getBuffer();
        bbEnt.rewind();
        bbEnt.limit(bbEnt.capacity() - 1);
        ArrayList<ByteBuffer> bbList = new ArrayList<ByteBuffer>();
        bbList.add(bbEnt);
        bbList.add(this.loadTitanfallEntityFile("env"));
        bbList.add(this.loadTitanfallEntityFile("fx"));
        bbList.add(this.loadTitanfallEntityFile("script"));
        bbList.add(this.loadTitanfallEntityFile("snd"));
        bbList.add(this.loadTitanfallEntityFile("spawn"));
        bbList.add(ByteBuffer.wrap(new byte[]{0}));
        ByteBuffer bbEntNew = ByteBufferUtils.concat(bbList);
        entlump.setBuffer(bbEntNew);
    }

    private ByteBuffer loadTitanfallEntityFile(String entname) {
        Path entFile = this.file.resolveSibling(String.format("%s_%s.ent", this.name, entname));
        ByteBuffer bb = ByteBuffer.allocate(0);
        try {
            if (Files.exists(entFile, new LinkOption[0]) && Files.size(entFile) > 12L) {
                bb = ByteBufferUtils.load(entFile);
                bb.position(11);
                bb.limit(bb.capacity() - 1);
                bb = bb.slice();
            }
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Unable to load entity file " + entFile.getFileName(), ex);
        }
        return bb;
    }

    private void loadGameLumps() {
        L.fine("Loading game lumps");
        try {
            Lump lump = this.getLump(LumpType.LUMP_GAME_LUMP);
            DataReader in = DataReaders.forByteBuffer(lump.getBuffer());
            if (this.version == 20 && this.bo == ByteOrder.LITTLE_ENDIAN && this.checkInvalidHeaders(in, false) && !this.checkInvalidHeaders(in, true)) {
                L.finer("Found Vindictus game lump header");
                this.app = SourceAppDB.getInstance().fromID(-100);
            }
            int glumps = in.readInt();
            for (int i = 0; i < glumps; ++i) {
                int lenOld;
                String glName;
                int vers;
                int flags;
                if (this.app.getAppID() == 2100) {
                    in.readInt();
                }
                int fourCC = in.readInt();
                if (this.app.getAppID() == -100) {
                    flags = in.readInt();
                    vers = in.readInt();
                } else {
                    flags = in.readUnsignedShort();
                    vers = in.readUnsignedShort();
                }
                int ofs = in.readInt();
                int len = in.readInt();
                if (flags == 1) {
                    in.seek(8L, Seekable.Origin.CURRENT);
                    int nextOfs = in.readInt();
                    if (nextOfs == 0) {
                        nextOfs = lump.getOffset() + lump.getLength();
                    }
                    len = nextOfs - ofs;
                    in.seek(-12L, Seekable.Origin.CURRENT);
                }
                if (ofs - lump.getOffset() > 0) {
                    ofs -= lump.getOffset();
                }
                if ((glName = StringMacroUtils.unmakeID(fourCC)).trim().isEmpty()) {
                    glName = "<dummy>";
                }
                if (ofs > lump.getLength()) {
                    int ofsOld = ofs;
                    ofs = lump.getLength();
                    len = 0;
                    L.log(Level.WARNING, "Invalid game lump offset {0} in {1}, assuming {2}", new Object[]{ofsOld, glName, ofs});
                } else if (ofs < 0) {
                    int ofsOld = ofs;
                    ofs = 0;
                    len = 0;
                    L.log(Level.WARNING, "Negative game lump offset {0} in {1}, assuming {2}", new Object[]{ofsOld, glName, ofs});
                }
                if (ofs + len > lump.getLength()) {
                    lenOld = len;
                    len = lump.getLength() - ofs;
                    L.log(Level.WARNING, "Invalid game lump length {0} in {1}, assuming {2}", new Object[]{lenOld, glName, len});
                } else if (len < 0) {
                    lenOld = len;
                    len = 0;
                    L.log(Level.WARNING, "Negative game lump length {0} in {1}, assuming {2}", new Object[]{lenOld, glName, len});
                }
                GameLump gl = new GameLump();
                gl.setBuffer(ByteBufferUtils.getSlice(lump.getBuffer(), ofs, len));
                gl.setOffset(ofs);
                gl.setFourCC(fourCC);
                gl.setFlags(flags);
                gl.setVersion(vers);
                this.gameLumps.add(gl);
            }
            L.log(Level.FINE, "Game lumps: {0}", glumps);
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Couldn't load game lumps", ex);
        }
    }

    private void saveGameLumps() {
        L.fine("Saving game lumps");
        int headerSize = 4;
        headerSize = this.app.getAppID() == -100 ? (headerSize += 20 * this.gameLumps.size()) : (headerSize += 16 * this.gameLumps.size());
        int dataSize = 0;
        for (GameLump gl : this.gameLumps) {
            dataSize += gl.getLength();
        }
        try {
            ByteBuffer bb = ByteBuffer.allocateDirect(headerSize + dataSize);
            bb.order(this.bo);
            DataWriter out = DataWriters.forByteBuffer(bb);
            out.writeInt(this.gameLumps.size());
            int offset = headerSize;
            for (GameLump gl : this.gameLumps) {
                gl.setOffset(offset);
                offset += gl.getLength();
                out.writeInt(gl.getFourCC());
                if (this.app.getAppID() == -100) {
                    out.writeInt(gl.getFlags());
                    out.writeInt(gl.getVersion());
                } else {
                    out.writeUnsignedShort(gl.getFlags());
                    out.writeUnsignedShort(gl.getVersion());
                }
                out.writeInt(gl.getOffset());
                out.writeInt(gl.getLength());
                bb.mark();
                bb.position(gl.getOffset());
                bb.put(gl.getBuffer());
                bb.reset();
            }
            Lump gameLump = this.getLump(LumpType.LUMP_GAME_LUMP);
            gameLump.setBuffer(bb);
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Couldn''t save game lumps", ex);
        }
    }

    private int fixLumpOffsets() {
        int offset = 1036;
        for (Lump lump : this.lumps) {
            if (lump.getLength() == 0) {
                lump.setOffset(0);
                continue;
            }
            lump.setOffset(offset);
            offset += lump.getLength();
        }
        return offset;
    }

    private void fixGameLumpOffsets(Lump lump) {
        ByteBuffer bb = lump.getBuffer();
        int glumps = bb.getInt();
        for (int i = 0; i < glumps; ++i) {
            int index = this.app.getAppID() == -100 ? 20 * i + 16 : 16 * i + 12;
            int ofs = bb.getInt(index);
            bb.putInt(index, ofs += lump.getOffset());
        }
    }

    private boolean checkInvalidHeaders(DataReader in, boolean vin) throws IOException {
        int glumps = in.readInt();
        for (int i = 0; i < glumps; ++i) {
            String glName = StringMacroUtils.unmakeID(in.readInt());
            if (!glName.matches("^[a-zA-Z0-9]{4}$")) {
                in.position(0L);
                return true;
            }
            in.seek(vin ? 16L : 12L, Seekable.Origin.CURRENT);
        }
        in.position(0L);
        return false;
    }

    public List<Lump> getLumps() {
        return Collections.unmodifiableList(this.lumps);
    }

    public Lump getLump(LumpType type) {
        return this.lumps.get(type.getIndex());
    }

    public List<GameLump> getGameLumps() {
        return Collections.unmodifiableList(this.gameLumps);
    }

    public GameLump getGameLump(String sid) {
        for (GameLump gl : this.gameLumps) {
            if (!gl.getName().equalsIgnoreCase(sid)) continue;
            return gl;
        }
        return null;
    }

    public void compress() {
        L.info("Compressing lumps");
        for (Lump l : this.lumps) {
            if (l.getType() == LumpType.LUMP_GAME_LUMP || l.getType() == LumpType.LUMP_PAKFILE || l.getLength() <= 17 || l.isCompressed()) continue;
            L.log(Level.FINE, "Compressing {0}", l.getName());
            l.compress();
        }
        for (GameLump gl : this.gameLumps) {
            if (gl.getLength() <= 17 || gl.isCompressed()) continue;
            L.log(Level.FINE, "Compressing {0}", gl.getName());
            gl.compress();
        }
        this.gameLumps.add(new GameLump());
    }

    public void uncompress() {
        L.info("Uncompressing lumps");
        for (Lump l : this.lumps) {
            if (!l.isCompressed()) continue;
            l.uncompress();
        }
        for (GameLump gl : this.gameLumps) {
            if (!gl.isCompressed()) continue;
            gl.uncompress();
        }
        if (!this.gameLumps.isEmpty() && this.gameLumps.get(this.gameLumps.size() - 1).getLength() == 0) {
            this.gameLumps.remove(this.gameLumps.size() - 1);
        }
    }

    public boolean isCompressed() {
        for (Lump l : this.lumps) {
            if (!l.isCompressed()) continue;
            return true;
        }
        return false;
    }

    public PakFile getPakFile() {
        return new PakFile(this);
    }

    public boolean canReadLump(LumpType type) {
        return type.getBspVersion() == -1 || type.getBspVersion() <= this.version;
    }

    public Path getNextLumpFile() {
        for (int i = 0; i < 128; ++i) {
            Path lumpFile = this.file.resolveSibling(String.format("%s_l_%d.lmp", this.name, i));
            if (Files.exists(lumpFile, new LinkOption[0])) continue;
            return lumpFile;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Path getFile() {
        return this.file;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) throws BspException {
        this.version = version;
    }

    public int getRevision() {
        return this.mapRev;
    }

    public void setRevision(int mapRev) {
        this.mapRev = mapRev;
    }

    public ByteOrder getByteOrder() {
        return this.bo;
    }

    public SourceApp getSourceApp() {
        return this.app;
    }

    public void setSourceApp(SourceApp appID) {
        this.app = appID;
    }

    public BspFileReader getReader() throws IOException {
        return new BspFileReader(this);
    }
}

