/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspinfo.gui.models;

import info.ata4.bsplib.BspFile;
import info.ata4.log.LogUtils;
import info.ata4.util.gui.ListTableModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class EmbeddedTableModel
extends ListTableModel {
    private static final Logger L = LogUtils.getLogger();

    public EmbeddedTableModel() {
        super(3);
        this.columnNames = Arrays.asList("Name", "Size");
        this.columnClasses = new Class[]{String.class, Long.class};
    }

    public EmbeddedTableModel(BspFile bspFile) {
        this();
        try (ZipFile zip = bspFile.getPakFile().getZipFile();){
            Enumeration<ZipArchiveEntry> enumeration = zip.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry ze = enumeration.nextElement();
                this.addRow(Arrays.asList(ze.getName(), ze.getSize()));
            }
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Can't read pak");
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

